/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.CompressedColumnarDoublesSuppliers;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.WritableSupplier;
import org.apache.druid.segment.nested.NestedDataColumnMetadata;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedFieldLiteralColumnIndexSupplier;
import org.apache.druid.segment.nested.NestedFieldLiteralDictionaryEncodedColumn;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.utils.CloseableUtils;

public final class CompressedNestedDataComplexColumn
extends NestedDataComplexColumn {
    private final NestedDataColumnMetadata metadata;
    private final Closer closer;
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private CompressedVariableSizedBlobColumn compressedRawColumn;
    private final ImmutableBitmap nullValues;
    private final GenericIndexed<String> fields;
    private final NestedLiteralTypeInfo fieldInfo;
    private final GenericIndexed<String> stringDictionary;
    private final FixedIndexed<Long> longDictionary;
    private final FixedIndexed<Double> doubleDictionary;
    private final SmooshedFileMapper fileMapper;
    private final ConcurrentHashMap<String, ColumnHolder> columns = new ConcurrentHashMap();
    private static final ObjectStrategy<Object> STRATEGY = NestedDataComplexTypeSerde.INSTANCE.getObjectStrategy();

    public CompressedNestedDataComplexColumn(NestedDataColumnMetadata metadata, ColumnConfig columnConfig, CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier, ImmutableBitmap nullValues, GenericIndexed<String> fields, NestedLiteralTypeInfo fieldInfo, GenericIndexed<String> stringDictionary, FixedIndexed<Long> longDictionary, FixedIndexed<Double> doubleDictionary, SmooshedFileMapper fileMapper) {
        this.metadata = metadata;
        this.nullValues = nullValues;
        this.fields = fields;
        this.fieldInfo = fieldInfo;
        this.stringDictionary = stringDictionary;
        this.longDictionary = longDictionary;
        this.doubleDictionary = doubleDictionary;
        this.fileMapper = fileMapper;
        this.closer = Closer.create();
        this.compressedRawColumnSupplier = compressedRawColumnSupplier;
    }

    public GenericIndexed<String> getFields() {
        return this.fields;
    }

    public NestedLiteralTypeInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public GenericIndexed<String> getStringDictionary() {
        return this.stringDictionary;
    }

    public FixedIndexed<Long> getLongDictionary() {
        return this.longDictionary;
    }

    public FixedIndexed<Double> getDoubleDictionary() {
        return this.doubleDictionary;
    }

    @Override
    @Nullable
    public Object getRowValue(int rowNum) {
        if (this.nullValues.get(rowNum)) {
            return null;
        }
        if (this.compressedRawColumn == null) {
            this.compressedRawColumn = (CompressedVariableSizedBlobColumn)this.closer.register((Closeable)this.compressedRawColumnSupplier.get());
        }
        ByteBuffer valueBuffer = this.compressedRawColumn.get(rowNum);
        return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        if (this.compressedRawColumn == null) {
            this.compressedRawColumn = (CompressedVariableSizedBlobColumn)this.closer.register((Closeable)this.compressedRawColumnSupplier.get());
        }
        return new ObjectColumnSelector(){

            @Override
            @Nullable
            public Object getObject() {
                if (CompressedNestedDataComplexColumn.this.nullValues.get(offset.getOffset())) {
                    return null;
                }
                ByteBuffer valueBuffer = CompressedNestedDataComplexColumn.this.compressedRawColumn.get(offset.getOffset());
                return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
            }

            @Override
            public Class classOfObject() {
                return CompressedNestedDataComplexColumn.this.getClazz();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", CompressedNestedDataComplexColumn.this);
            }
        };
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        if (this.compressedRawColumn == null) {
            this.compressedRawColumn = (CompressedVariableSizedBlobColumn)this.closer.register((Closeable)this.compressedRawColumnSupplier.get());
        }
        return new VectorObjectSelector(){
            final Object[] vector;
            private int id;
            {
                this.vector = new Object[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public Object[] getObjectVector() {
                if (this.id == offset.getId()) {
                    return this.vector;
                }
                if (offset.isContiguous()) {
                    int startOffset = offset.getStartOffset();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = this.getForOffset(startOffset + i);
                    }
                } else {
                    int[] offsets = offset.getOffsets();
                    int vectorSize = offset.getCurrentVectorSize();
                    for (int i = 0; i < vectorSize; ++i) {
                        this.vector[i] = this.getForOffset(offsets[i]);
                    }
                }
                this.id = offset.getId();
                return this.vector;
            }

            @Nullable
            private Object getForOffset(int offset2) {
                if (CompressedNestedDataComplexColumn.this.nullValues.get(offset2)) {
                    return null;
                }
                ByteBuffer valueBuffer = CompressedNestedDataComplexColumn.this.compressedRawColumn.get(offset2);
                return STRATEGY.fromByteBuffer(valueBuffer, valueBuffer.remaining());
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }
        };
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions((Closeable)this.closer);
    }

    @Override
    public DimensionSelector makeDimensionSelector(List<NestedPathPart> path, ReadableOffset readableOffset, ExtractionFn fn) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        if (this.fields.indexOf(field) >= 0) {
            DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(field).getColumn();
            return col.makeDimensionSelector(readableOffset, fn);
        }
        return DimensionSelector.constant(null);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(List<NestedPathPart> path, ReadableOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        if (this.fields.indexOf(field) >= 0) {
            BaseColumn col = this.getColumnHolder(field).getColumn();
            return col.makeColumnValueSelector(readableOffset);
        }
        return NilColumnValueSelector.instance();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(List<NestedPathPart> path, ReadableVectorOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        if (this.fields.indexOf(field) >= 0) {
            DictionaryEncodedColumn col = (DictionaryEncodedColumn)this.getColumnHolder(field).getColumn();
            return col.makeSingleValueDimensionVectorSelector(readableOffset);
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(List<NestedPathPart> path, ReadableVectorOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        if (this.fields.indexOf(field) >= 0) {
            BaseColumn col = this.getColumnHolder(field).getColumn();
            return col.makeVectorObjectSelector(readableOffset);
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(List<NestedPathPart> path, ReadableVectorOffset readableOffset) {
        String field = this.getField(path);
        Preconditions.checkNotNull((Object)field, (Object)"Null field");
        if (this.fields.indexOf(field) >= 0) {
            BaseColumn col = this.getColumnHolder(field).getColumn();
            return col.makeVectorValueSelector(readableOffset);
        }
        return NilVectorSelector.create(readableOffset);
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getColumnIndexSupplier(List<NestedPathPart> path) {
        String field = this.getField(path);
        if (this.fields.indexOf(field) < 0) {
            return null;
        }
        return this.getColumnHolder(field).getIndexSupplier();
    }

    @Override
    public boolean isNumeric(List<NestedPathPart> path) {
        String field = this.getField(path);
        if (this.fields.indexOf(field) < 0) {
            return true;
        }
        return this.getColumnHolder(field).getCapabilities().isNumeric();
    }

    private String getField(List<NestedPathPart> path) {
        return NestedPathFinder.toNormalizedJqPath(path);
    }

    private ColumnHolder getColumnHolder(String field) {
        return this.columns.computeIfAbsent(field, this::readNestedFieldColumn);
    }

    private ColumnHolder readNestedFieldColumn(String field) {
        try {
            if (this.fields.indexOf(field) < 0) {
                return null;
            }
            NestedLiteralTypeInfo.TypeSet types = this.fieldInfo.getTypes(this.fields.indexOf(field));
            ByteBuffer dataBuffer = this.fileMapper.mapFile(NestedDataColumnSerializer.getFieldFileName(this.metadata.getFileNameBase(), field));
            if (dataBuffer == null) {
                throw new ISE("Can't find field [%s] in [%s] file.", new Object[]{field, this.metadata.getFileNameBase()});
            }
            ColumnBuilder columnBuilder = new ColumnBuilder().setFileMapper(this.fileMapper);
            DictionaryEncodedColumnPartSerde.VERSION version = DictionaryEncodedColumnPartSerde.VERSION.fromByte(dataBuffer.get());
            int flags = dataBuffer.getInt();
            Preconditions.checkState((flags == 0 ? 1 : 0) != 0, (Object)StringUtils.format((String)"Unrecognized bits set in space reserved for future flags for field column [%s]", (Object[])new Object[]{field}));
            FixedIndexed<Integer> localDictionary = FixedIndexed.read(dataBuffer, NestedDataColumnSerializer.INT_TYPE_STRATEGY, this.metadata.getByteOrder(), 4);
            ByteBuffer bb = dataBuffer.asReadOnlyBuffer().order(this.metadata.getByteOrder());
            int longsLength = bb.getInt();
            int doublesLength = bb.getInt();
            dataBuffer.position(dataBuffer.position() + 4 + 4);
            int pos = dataBuffer.position();
            Supplier longs = longsLength > 0 ? CompressedColumnarLongsSupplier.fromByteBuffer(dataBuffer, this.metadata.getByteOrder()) : () -> null;
            dataBuffer.position(pos + longsLength);
            pos = dataBuffer.position();
            Supplier<ColumnarDoubles> doubles = doublesLength > 0 ? CompressedColumnarDoublesSuppliers.fromByteBuffer(dataBuffer, this.metadata.getByteOrder()) : () -> null;
            dataBuffer.position(pos + doublesLength);
            WritableSupplier<ColumnarInts> ints = version == DictionaryEncodedColumnPartSerde.VERSION.COMPRESSED ? CompressedVSizeColumnarIntsSupplier.fromByteBuffer(dataBuffer, this.metadata.getByteOrder()) : VSizeColumnarInts.readFromByteBuffer(dataBuffer);
            ColumnType theType = types.getSingleType();
            columnBuilder.setType(theType == null ? ValueType.STRING : (ValueType)theType.getType());
            GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(dataBuffer, this.metadata.getBitmapSerdeFactory().getObjectStrategy(), columnBuilder.getFileMapper());
            Supplier columnSupplier = () -> (NestedFieldLiteralDictionaryEncodedColumn)this.closer.register((Closeable)new NestedFieldLiteralDictionaryEncodedColumn(types, (ColumnarLongs)longs.get(), (ColumnarDoubles)doubles.get(), (ColumnarInts)ints.get(), this.stringDictionary, this.longDictionary, this.doubleDictionary, localDictionary, (Integer)localDictionary.get(0) == 0 ? (ImmutableBitmap)rBitmaps.get(0) : this.metadata.getBitmapSerdeFactory().getBitmapFactory().makeEmptyImmutableBitmap()));
            columnBuilder.setHasMultipleValues(false).setHasNulls(true).setDictionaryEncodedColumnSupplier(columnSupplier);
            columnBuilder.setIndexSupplier(new NestedFieldLiteralColumnIndexSupplier(types, this.metadata.getBitmapSerdeFactory().getBitmapFactory(), rBitmaps, localDictionary, this.stringDictionary, this.longDictionary, this.doubleDictionary), true, false);
            return columnBuilder.build();
        }
        catch (IOException ex) {
            throw new RE((Throwable)ex, "Failed to read data for [%s]", new Object[]{field});
        }
    }
}

