/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.SimpleBitmapColumnIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.column.SpatialIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.Utf8ValueSetIndex;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;

public class DictionaryEncodedStringIndexSupplier
implements ColumnIndexSupplier {
    private final BitmapFactory bitmapFactory;
    private final GenericIndexed<String> dictionary;
    private final GenericIndexed<ByteBuffer> dictionaryUtf8;
    @Nullable
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    @Nullable
    private final ImmutableRTree indexedTree;

    public DictionaryEncodedStringIndexSupplier(BitmapFactory bitmapFactory, GenericIndexed<String> dictionary, GenericIndexed<ByteBuffer> dictionaryUtf8, @Nullable GenericIndexed<ImmutableBitmap> bitmaps, @Nullable ImmutableRTree indexedTree) {
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.dictionaryUtf8 = dictionaryUtf8;
        this.bitmaps = bitmaps;
        this.indexedTree = indexedTree;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (this.bitmaps != null) {
            if (clazz.equals(NullValueIndex.class)) {
                SimpleImmutableBitmapIndex nullIndex = NullHandling.isNullOrEquivalent((String)this.dictionary.get(0)) ? new SimpleImmutableBitmapIndex(this.bitmaps.get(0)) : new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap());
                return (T)((NullValueIndex)() -> nullIndex);
            }
            if (clazz.equals(StringValueSetIndex.class)) {
                return (T)new GenericIndexedDictionaryEncodedStringValueSetIndex(this.bitmapFactory, this.dictionaryUtf8, this.bitmaps);
            }
            if (clazz.equals(Utf8ValueSetIndex.class)) {
                return (T)new GenericIndexedDictionaryEncodedStringValueSetIndex(this.bitmapFactory, this.dictionaryUtf8, this.bitmaps);
            }
            if (clazz.equals(DruidPredicateIndex.class)) {
                return (T)new GenericIndexedDictionaryEncodedStringDruidPredicateIndex(this.bitmapFactory, this.dictionary, this.bitmaps);
            }
            if (clazz.equals(LexicographicalRangeIndex.class)) {
                return (T)new GenericIndexedDictionaryEncodedColumnLexicographicalRangeIndex(this.bitmapFactory, this.dictionaryUtf8, this.bitmaps, NullHandling.isNullOrEquivalent((String)this.dictionary.get(0)));
            }
            if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
                return (T)new GenericIndexedDictionaryEncodedStringValueIndex(this.bitmapFactory, this.dictionary, this.bitmaps);
            }
        }
        if (this.indexedTree != null && clazz.equals(SpatialIndex.class)) {
            return (T)((SpatialIndex)() -> this.indexedTree);
        }
        return null;
    }

    public static final class GenericIndexedDictionaryEncodedColumnLexicographicalRangeIndex
    extends BaseGenericIndexedDictionaryEncodedIndex<ByteBuffer>
    implements LexicographicalRangeIndex {
        private final boolean hasNull;

        public GenericIndexedDictionaryEncodedColumnLexicographicalRangeIndex(BitmapFactory bitmapFactory, GenericIndexed<ByteBuffer> dictionary, GenericIndexed<ImmutableBitmap> bitmaps, boolean hasNull) {
            super(bitmapFactory, dictionary, bitmaps);
            this.hasNull = hasNull;
        }

        @Override
        public BitmapColumnIndex forRange(final @Nullable String startValue, final boolean startStrict, final @Nullable String endValue, final boolean endStrict) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    IntIntPair range = this.getRange(startValue, startStrict, endValue, endStrict);
                    final int start = range.leftInt();
                    final int end = range.rightInt();
                    return () -> new Iterator<ImmutableBitmap>(){
                        final IntIterator rangeIterator;
                        {
                            this.rangeIterator = IntListUtils.fromTo(start, end).iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.rangeIterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return this.getBitmap(this.rangeIterator.nextInt());
                        }
                    };
                }
            };
        }

        @Override
        public BitmapColumnIndex forRange(final @Nullable String startValue, final boolean startStrict, final @Nullable String endValue, final boolean endStrict, final Predicate<String> matcher) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    IntIntPair range = this.getRange(startValue, startStrict, endValue, endStrict);
                    final int start = range.leftInt();
                    final int end = range.rightInt();
                    return () -> new Iterator<ImmutableBitmap>(){
                        int currIndex;
                        int found;
                        {
                            this.currIndex = start;
                            this.found = this.findNext();
                        }

                        private int findNext() {
                            while (this.currIndex < end && !this.applyMatcher((ByteBuffer)dictionary.get(this.currIndex))) {
                                ++this.currIndex;
                            }
                            if (this.currIndex < end) {
                                return this.currIndex++;
                            }
                            return -1;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.found != -1;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            int cur = this.found;
                            if (cur == -1) {
                                throw new NoSuchElementException();
                            }
                            this.found = this.findNext();
                            return this.getBitmap(cur);
                        }
                    };
                }

                private boolean applyMatcher(@Nullable ByteBuffer valueUtf8) {
                    if (valueUtf8 == null) {
                        return matcher.apply(null);
                    }
                    return matcher.apply((Object)StringUtils.fromUtf8((ByteBuffer)valueUtf8.duplicate()));
                }
            };
        }

        private IntIntPair getRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
            String endValueToUse;
            String startValueToUse;
            int found;
            int firstValue;
            int n = firstValue = this.hasNull ? 1 : 0;
            int startIndex = startValue == null ? firstValue : ((found = this.dictionary.indexOf(StringUtils.toUtf8ByteBuffer((String)(startValueToUse = NullHandling.emptyToNullIfNeeded((String)startValue))))) >= firstValue ? (startStrict ? found + 1 : found) : -(found + 1));
            int endIndex = endValue == null ? this.dictionary.size() : ((found = this.dictionary.indexOf(StringUtils.toUtf8ByteBuffer((String)(endValueToUse = NullHandling.emptyToNullIfNeeded((String)endValue))))) >= firstValue ? (endStrict ? found : found + 1) : -(found + 1));
            endIndex = Math.max(startIndex, endIndex);
            return new IntIntImmutablePair(startIndex, endIndex);
        }
    }

    public static final class GenericIndexedDictionaryEncodedStringDruidPredicateIndex
    extends BaseGenericIndexedDictionaryEncodedIndex<String>
    implements DruidPredicateIndex {
        public GenericIndexedDictionaryEncodedStringDruidPredicateIndex(BitmapFactory bitmapFactory, GenericIndexed<String> dictionary, GenericIndexed<ImmutableBitmap> bitmaps) {
            super(bitmapFactory, dictionary, bitmaps);
        }

        @Override
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        @Nullable
                        String next;
                        boolean nextSet;
                        final Predicate stringPredicate;
                        final Iterator iterator;
                        {
                            this.stringPredicate = matcherFactory.makeStringPredicate();
                            this.iterator = dictionary.iterator();
                            this.next = null;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            int idx = dictionary.indexOf(this.next);
                            if (idx < 0) {
                                return bitmapFactory.makeEmptyImmutableBitmap();
                            }
                            ImmutableBitmap bitmap = (ImmutableBitmap)bitmaps.get(idx);
                            return bitmap == null ? bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                String nextValue = (String)this.iterator.next();
                                this.nextSet = this.stringPredicate.apply((Object)nextValue);
                                if (!this.nextSet) continue;
                                this.next = nextValue;
                            }
                        }
                    };
                }
            };
        }
    }

    public static final class GenericIndexedDictionaryEncodedStringValueSetIndex
    extends BaseGenericIndexedDictionaryEncodedIndex<ByteBuffer>
    implements StringValueSetIndex,
    Utf8ValueSetIndex {
        private static final int SIZE_WORTH_CHECKING_MIN = 8;

        public GenericIndexedDictionaryEncodedStringValueSetIndex(BitmapFactory bitmapFactory, GenericIndexed<ByteBuffer> dictionary, GenericIndexed<ImmutableBitmap> bitmaps) {
            super(bitmapFactory, dictionary, bitmaps);
        }

        @Override
        public BitmapColumnIndex forValue(final @Nullable String value) {
            return new SimpleBitmapColumnIndex(){

                @Override
                public double estimateSelectivity(int totalRows) {
                    return Math.min(1.0, (double)this.getBitmapForValue().size() / (double)totalRows);
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                    return bitmapResultFactory.wrapDimensionValue(this.getBitmapForValue());
                }

                private ImmutableBitmap getBitmapForValue() {
                    ByteBuffer valueUtf8 = value == null ? null : ByteBuffer.wrap(StringUtils.toUtf8((String)value));
                    int idx = dictionary.indexOf(valueUtf8);
                    return this.getBitmap(idx);
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(SortedSet<String> values) {
            return this.getBitmapColumnIndexForSortedIterableUtf8(Iterables.transform(values, input -> ByteBuffer.wrap(StringUtils.toUtf8((String)input))));
        }

        @Override
        public BitmapColumnIndex forSortedValuesUtf8(SortedSet<ByteBuffer> valuesUtf8) {
            SortedSet<ByteBuffer> tailSet;
            if (valuesUtf8.size() >= 8) {
                ByteBuffer minValueInColumn = (ByteBuffer)this.dictionary.get(0);
                tailSet = valuesUtf8.tailSet(minValueInColumn);
            } else {
                tailSet = valuesUtf8;
            }
            return this.getBitmapColumnIndexForSortedIterableUtf8(tailSet);
        }

        private BitmapColumnIndex getBitmapColumnIndexForSortedIterableUtf8(final Iterable<ByteBuffer> valuesUtf8) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    final int dictionarySize = dictionary.size();
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        final Iterator iterator;
                        {
                            this.iterator = valuesUtf8.iterator();
                            this.next = -1;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                ByteBuffer nextValue = (ByteBuffer)this.iterator.next();
                                this.next = dictionary.indexOf(nextValue);
                                if (this.next != -dictionarySize - 1) continue;
                                break;
                            }
                        }
                    };
                }
            };
        }
    }

    public static final class GenericIndexedDictionaryEncodedStringValueIndex
    extends BaseGenericIndexedDictionaryEncodedIndex<String>
    implements DictionaryEncodedStringValueIndex {
        public GenericIndexedDictionaryEncodedStringValueIndex(BitmapFactory bitmapFactory, GenericIndexed<String> dictionary, GenericIndexed<ImmutableBitmap> bitmaps) {
            super(bitmapFactory, dictionary, bitmaps);
        }

        @Override
        public int getCardinality() {
            return this.dictionary.size();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            return (String)this.dictionary.get(index);
        }
    }

    private static abstract class BaseGenericIndexedDictionaryEncodedIndex<T> {
        protected final BitmapFactory bitmapFactory;
        protected final Indexed<T> dictionary;
        protected final Indexed<ImmutableBitmap> bitmaps;

        protected BaseGenericIndexedDictionaryEncodedIndex(BitmapFactory bitmapFactory, GenericIndexed<T> dictionary, GenericIndexed<ImmutableBitmap> bitmaps) {
            this.bitmapFactory = bitmapFactory;
            this.dictionary = dictionary.singleThreaded();
            this.bitmaps = bitmaps.singleThreaded();
        }

        public ImmutableBitmap getBitmap(int idx) {
            if (idx < 0) {
                return this.bitmapFactory.makeEmptyImmutableBitmap();
            }
            ImmutableBitmap bitmap = this.bitmaps.get(idx);
            return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
        }
    }
}

