/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;

public class ExpressionPlan {
    private final ColumnInspector baseInputInspector;
    private final Expr expression;
    private final Expr.BindingAnalysis analysis;
    private final EnumSet<Trait> traits;
    @Nullable
    private final ExpressionType outputType;
    @Nullable
    private final ColumnType singleInputType;
    private final Set<String> unknownInputs;
    private final List<String> unappliedInputs;

    ExpressionPlan(ColumnInspector baseInputInspector, Expr expression, Expr.BindingAnalysis analysis, EnumSet<Trait> traits, @Nullable ExpressionType outputType, @Nullable ColumnType singleInputType, Set<String> unknownInputs, List<String> unappliedInputs) {
        this.baseInputInspector = baseInputInspector;
        this.expression = expression;
        this.analysis = analysis;
        this.traits = traits;
        this.outputType = outputType;
        this.singleInputType = singleInputType;
        this.unknownInputs = unknownInputs;
        this.unappliedInputs = unappliedInputs;
    }

    public boolean isConstant() {
        return this.analysis.getRequiredBindings().isEmpty();
    }

    public Expr getExpression() {
        return this.expression;
    }

    public Expr getAppliedExpression() {
        if (this.is(Trait.NEEDS_APPLIED)) {
            return Parser.applyUnappliedBindings((Expr)this.expression, (Expr.BindingAnalysis)this.analysis, this.unappliedInputs);
        }
        return this.expression;
    }

    public Expr getAppliedFoldExpression(String accumulatorId) {
        if (this.is(Trait.NEEDS_APPLIED)) {
            Preconditions.checkState((!this.unappliedInputs.contains(accumulatorId) ? 1 : 0) != 0, (Object)"Accumulator cannot be implicitly transformed, if it is an ARRAY or multi-valued type it must be used explicitly as such");
            return Parser.foldUnappliedBindings((Expr)this.expression, (Expr.BindingAnalysis)this.analysis, this.unappliedInputs, (String)accumulatorId);
        }
        return this.expression;
    }

    @Nullable
    public ExpressionType getOutputType() {
        return this.outputType;
    }

    @Nullable
    public ColumnType getSingleInputType() {
        return this.singleInputType;
    }

    public String getSingleInputName() {
        return (String)Iterables.getOnlyElement((Iterable)this.analysis.getRequiredBindings());
    }

    public Set<String> getUnknownInputs() {
        return this.unknownInputs;
    }

    public Expr.BindingAnalysis getAnalysis() {
        return this.analysis;
    }

    @Nullable
    public ColumnCapabilities inferColumnCapabilities(@Nullable ColumnType outputTypeHint) {
        if (this.outputType != null) {
            ColumnType inferredValueType = ExpressionType.toColumnType((ExpressionType)this.outputType);
            if (inferredValueType.is((TypeDescriptor)ValueType.COMPLEX)) {
                return ColumnCapabilitiesImpl.createDefault().setHasNulls(true).setType(inferredValueType);
            }
            if (inferredValueType.isNumeric()) {
                if (Types.is((TypeSignature)outputTypeHint, (TypeDescriptor)ValueType.FLOAT)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)ColumnType.FLOAT);
                }
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)inferredValueType);
            }
            if (outputTypeHint != null && outputTypeHint.isNumeric()) {
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)outputTypeHint);
            }
            if (inferredValueType.is((TypeDescriptor)ValueType.STRING)) {
                ColumnCapabilities underlyingCapabilities;
                if (this.isConstant()) {
                    return ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities().setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasNulls(this.expression.isNullLiteral());
                }
                if (this.any(Trait.SINGLE_INPUT_SCALAR, Trait.SINGLE_INPUT_MAPPABLE) && (underlyingCapabilities = this.baseInputInspector.getColumnCapabilities(this.getSingleInputName())) != null) {
                    return ColumnCapabilitiesImpl.copyOf(underlyingCapabilities).setType(ColumnType.STRING).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false).setHasBitmapIndexes(false).setHasNulls(true);
                }
            }
            if (this.any(Trait.NON_SCALAR_OUTPUT, Trait.NEEDS_APPLIED)) {
                if (Types.is((TypeSignature)outputTypeHint, (TypeDescriptor)ValueType.STRING) || inferredValueType.is((TypeDescriptor)ValueType.STRING)) {
                    return ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities().setHasMultipleValues(true);
                }
                return ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities((TypeSignature<ValueType>)ExpressionType.toColumnType((ExpressionType)this.outputType));
            }
            return ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities();
        }
        return null;
    }

    public boolean is(Trait ... flags) {
        return ExpressionPlan.is(this.traits, flags);
    }

    public boolean any(Trait ... flags) {
        return ExpressionPlan.any(this.traits, flags);
    }

    static boolean is(EnumSet<Trait> traits, Trait ... args) {
        return Arrays.stream(args).allMatch(traits::contains);
    }

    static boolean any(EnumSet<Trait> traits, Trait ... args) {
        return Arrays.stream(args).anyMatch(traits::contains);
    }

    static boolean none(EnumSet<Trait> traits, Trait ... args) {
        return Arrays.stream(args).noneMatch(traits::contains);
    }

    public static enum Trait {
        CONSTANT,
        IDENTIFIER,
        SINGLE_INPUT_SCALAR,
        SINGLE_INPUT_MAPPABLE,
        NEEDS_APPLIED,
        UNKNOWN_INPUTS,
        INCOMPLETE_INPUTS,
        NON_SCALAR_INPUTS,
        NON_SCALAR_OUTPUT,
        VECTORIZABLE;

    }
}

