/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.ComplexFieldReader;
import org.apache.druid.frame.field.ComplexFieldWriter;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class ComplexFieldReaderTest
extends InitializedNullHandlingTest {
    private static final ComplexMetricSerde SERDE = new StringComplexMetricSerde();
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public BaseObjectColumnValueSelector<String> writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = new ComplexFieldWriter(SERDE, this.writeSelector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_createFromType_notComplex() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ComplexFieldReader.createFromType((ColumnType)ColumnType.LONG));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Expected complex type")));
    }

    @Test
    public void test_createFromType_noComplexSerde() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ComplexFieldReader.createFromType((ColumnType)ColumnType.ofComplex((String)"no-serde")));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"No serde for complexTypeName[no-serde]")));
    }

    @Test
    public void test_makeColumnValueSelector_null() {
        this.writeToMemory(null);
        ColumnValueSelector readSelector = new ComplexFieldReader(SERDE).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertNull((Object)readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_aValue() {
        this.writeToMemory("foo");
        ColumnValueSelector readSelector = new ComplexFieldReader(SERDE).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertEquals((Object)"foo", (Object)readSelector.getObject());
    }

    private void writeToMemory(String value) {
        Mockito.when((Object)this.writeSelector.getObject()).thenReturn((Object)value);
        if (this.fieldWriter.writeTo(this.memory, 1L, this.memory.getCapacity() - 1L) < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
    }

    private static class StringComplexMetricSerde
    extends ComplexMetricSerde {
        private StringComplexMetricSerde() {
        }

        public String getTypeName() {
            return "testString";
        }

        public ComplexMetricExtractor getExtractor() {
            throw new UnsupportedOperationException();
        }

        public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
            throw new UnsupportedOperationException();
        }

        public ObjectStrategy getObjectStrategy() {
            return new ObjectStrategy<String>(){

                public Class<String> getClazz() {
                    return String.class;
                }

                public String fromByteBuffer(ByteBuffer buffer, int numBytes) {
                    return StringUtils.fromUtf8((ByteBuffer)buffer, (int)numBytes);
                }

                public byte[] toBytes(@Nullable String val) {
                    return StringUtils.toUtf8WithNullToEmpty((String)val);
                }

                public int compare(String o1, String o2) {
                    return Comparators.naturalNullsFirst().compare((Object)o1, (Object)o2);
                }
            };
        }
    }
}

