/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.util.Objects;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.FloatFieldReader;
import org.apache.druid.frame.field.FloatFieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class FloatFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public BaseFloatColumnValueSelector writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = new FloatFieldWriter(this.writeSelector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_makeColumnValueSelector_defaultOrNull() {
        this.writeToMemory(NullHandling.defaultFloatValue());
        ColumnValueSelector readSelector = new FloatFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertEquals((Object)(!NullHandling.replaceWithDefault() ? 1 : 0), (Object)readSelector.isNull());
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((float)NullHandling.defaultFloatValue().floatValue(), (float)readSelector.getFloat(), (float)0.0f);
        }
    }

    @Test
    public void test_makeColumnValueSelector_aValue() {
        this.writeToMemory(Float.valueOf(5.1f));
        ColumnValueSelector readSelector = new FloatFieldReader().makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertEquals((Object)Float.valueOf(5.1f), (Object)readSelector.getObject());
    }

    @Test
    public void test_makeDimensionSelector_defaultOrNull() {
        this.writeToMemory(NullHandling.defaultFloatValue());
        DimensionSelector readSelector = new FloatFieldReader().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? "0.0" : null), (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        if (NullHandling.replaceWithDefault()) {
            Assert.assertTrue((boolean)readSelector.makeValueMatcher("0.0").matches());
            Assert.assertFalse((boolean)readSelector.makeValueMatcher((String)null).matches());
            Assert.assertTrue((boolean)readSelector.makeValueMatcher("0.0"::equals).matches());
            Assert.assertFalse((boolean)readSelector.makeValueMatcher(Objects::isNull).matches());
        } else {
            Assert.assertFalse((boolean)readSelector.makeValueMatcher("0.0").matches());
            Assert.assertTrue((boolean)readSelector.makeValueMatcher((String)null).matches());
            Assert.assertFalse((boolean)readSelector.makeValueMatcher("0.0"::equals).matches());
            Assert.assertTrue((boolean)readSelector.makeValueMatcher(Objects::isNull).matches());
        }
    }

    @Test
    public void test_makeDimensionSelector_aValue() {
        this.writeToMemory(Float.valueOf(5.1f));
        DimensionSelector readSelector = new FloatFieldReader().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"5.1", (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("5.1").matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("5").matches());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("5.1"::equals).matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("5"::equals).matches());
    }

    @Test
    public void test_makeDimensionSelector_aValue_extractionFn() {
        this.writeToMemory(Float.valueOf(20.5f));
        DimensionSelector readSelector = new FloatFieldReader().makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L), (ExtractionFn)new SubstringDimExtractionFn(1, null));
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"0.5", (Object)readSelector.lookupName(0));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(String.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("0.5").matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("2").matches());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("0.5"::equals).matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("2"::equals).matches());
    }

    private void writeToMemory(Float value) {
        Mockito.when((Object)this.writeSelector.isNull()).thenReturn((Object)(value == null ? 1 : 0));
        if (value != null) {
            Mockito.when((Object)Float.valueOf(this.writeSelector.getFloat())).thenReturn((Object)value);
        }
        if (this.fieldWriter.writeTo(this.memory, 1L, this.memory.getCapacity() - 1L) < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
    }
}

