/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.java.util.common.ISE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SuperSorterProgressTrackerTest {
    SuperSorterProgressTracker superSorterProgressTracker;

    @Before
    public void setup() {
        this.superSorterProgressTracker = new SuperSorterProgressTracker();
    }

    @Test
    public void testSetTotalMergingLevelsMultipleTimes() {
        ISE exception = (ISE)Assert.assertThrows(ISE.class, () -> {
            this.superSorterProgressTracker.setTotalMergingLevels(5);
            this.superSorterProgressTracker.setTotalMergingLevels(5);
        });
        Assert.assertEquals((Object)"Total merging levels already defined for the merge sort.", (Object)exception.getMessage());
    }

    @Test
    public void testSetTotalMergingLevelsWithConflictingDataWithTotalMergers() {
        this.superSorterProgressTracker.setTotalMergersForLevel(3, 8L);
        ISE exception = (ISE)Assert.assertThrows(ISE.class, () -> this.superSorterProgressTracker.setTotalMergingLevels(2));
        Assert.assertEquals((Object)"Max level found in levelToTotalBatches is 3 (0-indexed). Cannot set totalMergingLevels to 2", (Object)exception.getMessage());
    }

    @Test
    public void testSetTotalMergingLevelsWithConflictingDataWithMergedBatches() {
        this.superSorterProgressTracker.addMergedBatchesForLevel(3, 8L);
        ISE exception = (ISE)Assert.assertThrows(ISE.class, () -> this.superSorterProgressTracker.setTotalMergingLevels(3));
        Assert.assertEquals((Object)"Max level found in levelToMergedBatches is 3 (0-indexed). Cannot set totalMergingLevels to 3", (Object)exception.getMessage());
    }

    @Test
    public void testSetTotalMergersForLevelIncorrectly() {
        this.superSorterProgressTracker.setTotalMergingLevels(4);
        this.superSorterProgressTracker.setTotalMergersForLevel(2, 8L);
        this.superSorterProgressTracker.setTotalMergersForLevel(3, 8L);
        ISE exception1 = (ISE)Assert.assertThrows(ISE.class, () -> this.superSorterProgressTracker.setTotalMergersForLevel(-1, 4L));
        Assert.assertEquals((Object)"Unable to set 4 total mergers for level -1. Level must be non-negative", (Object)exception1.getMessage());
        ISE exception2 = (ISE)Assert.assertThrows(ISE.class, () -> this.superSorterProgressTracker.setTotalMergersForLevel(4, 1L));
        Assert.assertEquals((Object)"Cannot set total mergers for level 4. Valid levels range from 0 to 3", (Object)exception2.getMessage());
        ISE exception3 = (ISE)Assert.assertThrows(ISE.class, () -> this.superSorterProgressTracker.setTotalMergersForLevel(2, 16L));
        Assert.assertEquals((Object)"Total mergers are already present for the level 2", (Object)exception3.getMessage());
        this.superSorterProgressTracker.setTotalMergersForLevel(3, 16L);
    }

    @Test
    public void testSetMergersForUltimateLevelMultipleTimes() {
        ISE exception = (ISE)Assert.assertThrows(ISE.class, () -> {
            this.superSorterProgressTracker.setTotalMergersForUltimateLevel(5L);
            this.superSorterProgressTracker.setTotalMergersForUltimateLevel(5L);
        });
        Assert.assertEquals((Object)"Cannot set mergers for final level more than once", (Object)exception.getMessage());
    }

    @Test
    public void testAddMergedBatchesForLevelIncorrectly() {
        this.superSorterProgressTracker.setTotalMergingLevels(4);
        ISE exception = (ISE)Assert.assertThrows(ISE.class, () -> this.superSorterProgressTracker.addMergedBatchesForLevel(5, 4L));
        Assert.assertEquals((Object)"Cannot add merged batches for level 5. Valid levels range from 0 to 3", (Object)exception.getMessage());
    }
}

