/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;

public class ChompingFrameProcessor
implements FrameProcessor<Long> {
    private final List<ReadableFrameChannel> channels;
    private final IntSet awaitSet;
    private final CountDownLatch didReadFrame = new CountDownLatch(1);
    private final AtomicBoolean didCleanup = new AtomicBoolean(false);
    private long numFrames = 0L;

    public ChompingFrameProcessor(List<ReadableFrameChannel> channels) {
        this.channels = channels;
        this.awaitSet = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)channels.size()));
    }

    public List<ReadableFrameChannel> inputChannels() {
        return this.channels;
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.emptyList();
    }

    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) {
        IntIterator intIterator = readableInputs.iterator();
        while (intIterator.hasNext()) {
            int channelNumber = (Integer)intIterator.next();
            ReadableFrameChannel channel = this.channels.get(channelNumber);
            if (channel.isFinished()) {
                this.awaitSet.remove(channelNumber);
                continue;
            }
            channel.read();
            this.didReadFrame.countDown();
            ++this.numFrames;
        }
        if (this.awaitSet.isEmpty()) {
            return ReturnOrAwait.returnObject((Object)this.numFrames);
        }
        return ReturnOrAwait.awaitAny((IntSet)this.awaitSet);
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
        this.didCleanup.set(true);
    }

    public void awaitRead() throws InterruptedException {
        this.didReadFrame.await();
    }

    public boolean didCleanup() {
        return this.didCleanup.get();
    }
}

