/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.util.Collections;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.frame.write.RowBasedFrameWriterFactory;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.frame.write.columnar.ColumnarFrameWriterFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.filter.AllNullColumnSelectorFactory;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class FrameWritersTest
extends InitializedNullHandlingTest {
    private static final int ALLOCATOR_CAPACITY = 1000;

    @Test
    public void test_rowBased() {
        FrameWriterFactory factory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).build(), Collections.singletonList(new SortColumn("x", false)));
        MatcherAssert.assertThat((Object)factory, (Matcher)CoreMatchers.instanceOf(RowBasedFrameWriterFactory.class));
        Assert.assertEquals((long)1000L, (long)factory.allocatorCapacity());
    }

    @Test
    public void test_columnar() {
        FrameWriterFactory factory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.COLUMNAR, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).build(), Collections.emptyList());
        MatcherAssert.assertThat((Object)factory, (Matcher)CoreMatchers.instanceOf(ColumnarFrameWriterFactory.class));
        Assert.assertEquals((long)1000L, (long)factory.allocatorCapacity());
    }

    @Test
    public void test_rowBased_unsupportedSortingColumnType() {
        UnsupportedColumnTypeException e = (UnsupportedColumnTypeException)Assert.assertThrows(UnsupportedColumnTypeException.class, () -> FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG_ARRAY).build(), Collections.singletonList(new SortColumn("x", false))));
        Assert.assertEquals((Object)"x", (Object)e.getColumnName());
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)e.getColumnType());
    }

    @Test
    public void test_rowBased_unsupportedNonSortingColumnType() {
        FrameWriterFactory factory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG_ARRAY).build(), Collections.emptyList());
        UnsupportedColumnTypeException e = (UnsupportedColumnTypeException)Assert.assertThrows(UnsupportedColumnTypeException.class, () -> factory.newFrameWriter((ColumnSelectorFactory)new AllNullColumnSelectorFactory()));
        Assert.assertEquals((Object)"x", (Object)e.getColumnName());
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)e.getColumnType());
    }

    @Test
    public void test_columnar_unsupportedColumnType() {
        FrameWriterFactory factory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.COLUMNAR, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG_ARRAY).build(), Collections.emptyList());
        UnsupportedColumnTypeException e = (UnsupportedColumnTypeException)Assert.assertThrows(UnsupportedColumnTypeException.class, () -> factory.newFrameWriter((ColumnSelectorFactory)new AllNullColumnSelectorFactory()));
        Assert.assertEquals((Object)"x", (Object)e.getColumnName());
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)e.getColumnType());
    }

    @Test
    public void test_rowBased_unsupportedSortColumnType() {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", HyperUniquesAggregatorFactory.TYPE).build(), Collections.singletonList(new SortColumn("x", false))));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Sort column [x] is not comparable (type = COMPLEX<hyperUnique>)")));
    }

    @Test
    public void test_rowBased_sortColumnsNotPrefix() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).add("y", ColumnType.LONG).build(), Collections.singletonList(new SortColumn("y", false))));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Sort column [y] must be a prefix of the signature")));
    }

    @Test
    public void test_columnar_cantSort() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> FrameWriters.makeFrameWriterFactory((FrameType)FrameType.COLUMNAR, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).build(), Collections.singletonList(new SortColumn("x", false))));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Columnar frames cannot be sorted")));
    }
}

