/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ExtensionsLoaderTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    private Injector startupInjector() {
        return new StartupInjectorBuilder().withEmptyProperties().withExtensions().build();
    }

    @Test
    public void test02MakeStartupInjector() {
        Injector startupInjector = this.startupInjector();
        Assert.assertNotNull((Object)startupInjector);
        Assert.assertNotNull((Object)startupInjector.getInstance(ObjectMapper.class));
        ExtensionsLoader extnLoader = ExtensionsLoader.instance((Injector)startupInjector);
        Assert.assertNotNull((Object)extnLoader);
        Assert.assertSame((Object)extnLoader, (Object)ExtensionsLoader.instance((Injector)startupInjector));
    }

    @Test
    public void test04DuplicateClassLoaderExtensions() throws Exception {
        File extensionDir = this.temporaryFolder.newFolder();
        Injector startupInjector = this.startupInjector();
        ExtensionsLoader extnLoader = ExtensionsLoader.instance((Injector)startupInjector);
        Pair key = Pair.of((Object)extensionDir, (Object)true);
        extnLoader.getLoadersMap().put(key, new URLClassLoader(new URL[0], ExtensionsLoader.class.getClassLoader()));
        Collection modules = extnLoader.getFromExtensions(DruidModule.class);
        HashSet<String> loadedModuleNames = new HashSet<String>();
        for (DruidModule module : modules) {
            Assert.assertFalse((String)"Duplicate extensions are loaded", (boolean)loadedModuleNames.contains(module.getClass().getName()));
            loadedModuleNames.add(module.getClass().getName());
        }
    }

    @Test
    public void test06GetClassLoaderForExtension() throws IOException {
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig());
        File some_extension_dir = this.temporaryFolder.newFolder();
        File a_jar = new File(some_extension_dir, "a.jar");
        File b_jar = new File(some_extension_dir, "b.jar");
        File c_jar = new File(some_extension_dir, "c.jar");
        a_jar.createNewFile();
        b_jar.createNewFile();
        c_jar.createNewFile();
        URLClassLoader loader = extnLoader.getClassLoaderForExtension(some_extension_dir, false);
        Object[] expectedURLs = new URL[]{a_jar.toURI().toURL(), b_jar.toURI().toURL(), c_jar.toURI().toURL()};
        Object[] actualURLs = loader.getURLs();
        Arrays.sort(actualURLs, Comparator.comparing(URL::getPath));
        Assert.assertArrayEquals((Object[])expectedURLs, (Object[])actualURLs);
    }

    @Test
    public void testGetLoadedModules() {
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig());
        Collection modules = extnLoader.getModules();
        HashSet moduleSet = new HashSet(modules);
        Collection loadedModules = extnLoader.getModules();
        Assert.assertEquals((String)"Set from loaded modules #1 should be same!", (long)modules.size(), (long)loadedModules.size());
        Assert.assertEquals((String)"Set from loaded modules #1 should be same!", moduleSet, new HashSet(loadedModules));
        Collection loadedModules2 = extnLoader.getModules();
        Assert.assertEquals((String)"Set from loaded modules #2 should be same!", (long)modules.size(), (long)loadedModules2.size());
        Assert.assertEquals((String)"Set from loaded modules #2 should be same!", moduleSet, new HashSet(loadedModules2));
    }

    @Test
    public void testGetExtensionFilesToLoad_non_exist_extensions_dir() throws IOException {
        final File tmpDir = this.temporaryFolder.newFolder();
        Assert.assertTrue((String)"could not create missing folder", (!tmpDir.exists() || tmpDir.delete() ? 1 : 0) != 0);
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig(){

            public String getDirectory() {
                return tmpDir.getAbsolutePath();
            }
        });
        Assert.assertArrayEquals((String)"Non-exist root extensionsDir should return an empty array of File", (Object[])new File[0], (Object[])extnLoader.getExtensionFilesToLoad());
    }

    @Test(expected=ISE.class)
    public void testGetExtensionFilesToLoad_wrong_type_extensions_dir() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFile();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config);
        extnLoader.getExtensionFilesToLoad();
    }

    @Test
    public void testGetExtensionFilesToLoad_empty_extensions_dir() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config);
        Assert.assertArrayEquals((String)"Empty root extensionsDir should return an empty array of File", (Object[])new File[0], (Object[])extnLoader.getExtensionFilesToLoad());
    }

    @Test
    public void testGetExtensionFilesToLoad_null_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config);
        File mysql_metadata_storage = new File(extensionsDir, "mysql-metadata-storage");
        mysql_metadata_storage.mkdir();
        Object[] expectedFileList = new File[]{mysql_metadata_storage};
        Object[] actualFileList = extnLoader.getExtensionFilesToLoad();
        Arrays.sort(actualFileList);
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }

    @Test
    public void testGetExtensionFilesToLoad_with_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        final File absolutePathExtension = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public LinkedHashSet<String> getLoadList() {
                return Sets.newLinkedHashSet(Arrays.asList("mysql-metadata-storage", absolutePathExtension.getAbsolutePath()));
            }

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config);
        File mysql_metadata_storage = new File(extensionsDir, "mysql-metadata-storage");
        File random_extension = new File(extensionsDir, "random-extensions");
        mysql_metadata_storage.mkdir();
        random_extension.mkdir();
        Object[] expectedFileList = new File[]{mysql_metadata_storage, absolutePathExtension};
        Object[] actualFileList = extnLoader.getExtensionFilesToLoad();
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }

    @Test(expected=ISE.class)
    public void testGetExtensionFilesToLoad_with_non_exist_item_in_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public LinkedHashSet<String> getLoadList() {
                return Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"mysql-metadata-storage"));
            }

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        File random_extension = new File(extensionsDir, "random-extensions");
        random_extension.mkdir();
        ExtensionsLoader extnLoader = new ExtensionsLoader(config);
        extnLoader.getExtensionFilesToLoad();
    }

    @Test
    public void testGetURLsForClasspath() throws Exception {
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        File tmpDir1a = new File(tmpDir1, "a.jar");
        tmpDir1a.createNewFile();
        File tmpDir1b = new File(tmpDir1, "b.jar");
        tmpDir1b.createNewFile();
        new File(tmpDir1, "note1.txt").createNewFile();
        File tmpDir2c = new File(tmpDir2, "c.jar");
        tmpDir2c.createNewFile();
        File tmpDir2d = new File(tmpDir2, "d.jar");
        tmpDir2d.createNewFile();
        File tmpDir2e = new File(tmpDir2, "e.JAR");
        tmpDir2e.createNewFile();
        new File(tmpDir2, "note2.txt").createNewFile();
        String cp = tmpDir1.getAbsolutePath() + File.separator + "*" + File.pathSeparator + tmpDir3.getAbsolutePath() + File.pathSeparator + tmpDir2.getAbsolutePath() + File.separator + "*";
        List urLsForClasspath = ExtensionsLoader.getURLsForClasspath((String)cp);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new URL[]{tmpDir1a.toURI().toURL(), tmpDir1b.toURI().toURL()}), (Object)Sets.newHashSet(urLsForClasspath.subList(0, 2)));
        Assert.assertEquals((Object)tmpDir3.toURI().toURL(), urLsForClasspath.get(2));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new URL[]{tmpDir2c.toURI().toURL(), tmpDir2d.toURI().toURL(), tmpDir2e.toURI().toURL()}), (Object)Sets.newHashSet(urLsForClasspath.subList(3, 6)));
    }

    @Test
    public void testExtensionsWithSameDirName() throws Exception {
        String extensionName = "some_extension";
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File extension1 = new File(tmpDir1, "some_extension");
        File extension2 = new File(tmpDir2, "some_extension");
        Assert.assertTrue((boolean)extension1.mkdir());
        Assert.assertTrue((boolean)extension2.mkdir());
        File jar1 = new File(extension1, "jar1.jar");
        File jar2 = new File(extension2, "jar2.jar");
        Assert.assertTrue((boolean)jar1.createNewFile());
        Assert.assertTrue((boolean)jar2.createNewFile());
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig());
        URLClassLoader classLoader1 = extnLoader.getClassLoaderForExtension(extension1, false);
        URLClassLoader classLoader2 = extnLoader.getClassLoaderForExtension(extension2, false);
        Assert.assertArrayEquals((Object[])new URL[]{jar1.toURI().toURL()}, (Object[])classLoader1.getURLs());
        Assert.assertArrayEquals((Object[])new URL[]{jar2.toURI().toURL()}, (Object[])classLoader2.getURLs());
    }
}

