/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import junitparams.converters.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.GroupingAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.constant.LongConstantAggregator;
import org.apache.druid.query.aggregation.constant.LongConstantBufferAggregator;
import org.apache.druid.query.aggregation.constant.LongConstantVectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class GroupingAggregatorFactoryTest {
    public static GroupingAggregatorFactory makeFactory(String[] groupings, @Nullable String[] keyDims) {
        GroupingAggregatorFactory factory = new GroupingAggregatorFactory("name", Arrays.asList(groupings));
        if (null != keyDims) {
            factory = factory.withKeyDimensions((Set)Sets.newHashSet((Object[])keyDims));
        }
        return factory;
    }

    @RunWith(value=Parameterized.class)
    public static class ValueTests {
        private final GroupingAggregatorFactory factory;
        private final long value;

        public ValueTests(String[] groupings, @Nullable String[] keyDimensions, long value) {
            this.factory = GroupingAggregatorFactoryTest.makeFactory(groupings, keyDimensions);
            this.value = value;
        }

        @Parameterized.Parameters
        public static Collection arguments() {
            String[] maxGroupingList = new String[63];
            for (int i = 0; i < maxGroupingList.length; ++i) {
                maxGroupingList[i] = String.valueOf(i);
            }
            return Arrays.asList({new String[]{"a", "b"}, new String[0], 3}, {new String[]{"a", "b"}, null, 0}, {new String[]{"a", "b"}, new String[]{"a"}, 1}, {new String[]{"a", "b"}, new String[]{"b"}, 2}, {new String[]{"a", "b"}, new String[]{"a", "b"}, 0}, {new String[]{"b", "a"}, new String[]{"a"}, 2}, {maxGroupingList, null, 0}, {maxGroupingList, new String[0], Long.MAX_VALUE});
        }

        @Test
        public void testValue() {
            Assert.assertEquals((long)this.value, (long)this.factory.factorize(null).getLong());
        }
    }

    public static class GroupingDimensionsTest {
        @Rule
        public ExpectedException exception = ExpectedException.none();

        @Test
        public void testFactory_nullGroupingDimensions() {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("Must have a non-empty grouping dimensions");
            GroupingAggregatorFactory factory = new GroupingAggregatorFactory("name", null, (Set)Sets.newHashSet((Object[])new String[]{"b"}));
        }

        @Test
        public void testFactory_emptyGroupingDimensions() {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("Must have a non-empty grouping dimensions");
            GroupingAggregatorFactoryTest.makeFactory(new String[0], null);
        }

        @Test
        public void testFactory_highNumberOfGroupingDimensions() {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage(StringUtils.format((String)"Number of dimensions %d is more than supported %d", (Object[])new Object[]{64, 63}));
            GroupingAggregatorFactoryTest.makeFactory(new String[64], null);
        }
    }

    public static class NewAggregatorTests {
        private ColumnSelectorFactory metricFactory;

        @Before
        public void setup() {
            this.metricFactory = (ColumnSelectorFactory)EasyMock.mock(ColumnSelectorFactory.class);
        }

        @Test
        public void testNewAggregator() {
            GroupingAggregatorFactory factory = GroupingAggregatorFactoryTest.makeFactory(new String[]{"a", "b"}, new String[]{"a"});
            Aggregator aggregator = factory.factorize(this.metricFactory);
            Assert.assertEquals(LongConstantAggregator.class, aggregator.getClass());
            Assert.assertEquals((long)1L, (long)aggregator.getLong());
        }

        @Test
        public void testNewBufferAggregator() {
            GroupingAggregatorFactory factory = GroupingAggregatorFactoryTest.makeFactory(new String[]{"a", "b"}, new String[]{"a"});
            BufferAggregator aggregator = factory.factorizeBuffered(this.metricFactory);
            Assert.assertEquals(LongConstantBufferAggregator.class, aggregator.getClass());
            Assert.assertEquals((long)1L, (long)aggregator.getLong(null, 0));
        }

        @Test
        public void testNewVectorAggregator() {
            GroupingAggregatorFactory factory = GroupingAggregatorFactoryTest.makeFactory(new String[]{"a", "b"}, new String[]{"a"});
            Assert.assertTrue((boolean)factory.canVectorize((ColumnInspector)this.metricFactory));
            VectorAggregator aggregator = factory.factorizeVector(null);
            Assert.assertEquals(LongConstantVectorAggregator.class, aggregator.getClass());
            Assert.assertEquals((Object)1L, (Object)aggregator.get(null, 0));
        }

        @Test
        public void testWithKeyDimensions() {
            GroupingAggregatorFactory factory = GroupingAggregatorFactoryTest.makeFactory(new String[]{"a", "b"}, new String[]{"a"});
            Aggregator aggregator = factory.factorize(this.metricFactory);
            Assert.assertEquals((long)1L, (long)aggregator.getLong());
            factory = factory.withKeyDimensions((Set)Sets.newHashSet((Object[])new String[]{"b"}));
            aggregator = factory.factorize(this.metricFactory);
            Assert.assertEquals((long)2L, (long)aggregator.getLong());
        }
    }
}

