/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleSumAggregator;
import org.apache.druid.query.aggregation.JavaScriptAggregator;
import org.apache.druid.query.aggregation.JavaScriptAggregatorBenchmark;
import org.apache.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.druid.query.aggregation.JavaScriptBufferAggregator;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.TestFloatColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptAggregatorTest {
    protected static final Map<String, String> SUM_LOG_A_TIMES_B_PLUS_TEN = new HashMap<String, String>();
    protected static final Map<String, String> SCRIPT_DOUBLE_SUM = new HashMap<String, String>();
    final ColumnSelectorFactory DUMMY_COLUMN_SELECTOR_FACTORY = new ColumnSelectorFactory(){

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return null;
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            return null;
        }

        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return null;
        }
    };
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    private static void aggregate(TestDoubleColumnSelectorImpl selector1, TestDoubleColumnSelectorImpl selector2, Aggregator agg) {
        agg.aggregate();
        selector1.increment();
        selector2.increment();
    }

    private void aggregateBuffer(TestFloatColumnSelector selector1, TestFloatColumnSelector selector2, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        selector1.increment();
        selector2.increment();
    }

    private static void aggregate(TestDoubleColumnSelectorImpl selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private static void aggregate(TestObjectColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        TestDoubleColumnSelectorImpl selector1 = new TestDoubleColumnSelectorImpl(new double[]{42.12, 9.0});
        TestDoubleColumnSelectorImpl selector2 = new TestDoubleColumnSelectorImpl(new double[]{2.0, 3.0});
        Map<String, String> script = SUM_LOG_A_TIMES_B_PLUS_TEN;
        JavaScriptAggregator agg = new JavaScriptAggregator(Arrays.asList(selector1, selector2), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        double val = 10.0;
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(selector1, selector2, (Aggregator)agg);
        Assert.assertEquals((Object)(val += Math.log(42.12) * 2.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(selector1, selector2, (Aggregator)agg);
        Assert.assertEquals((Object)(val += Math.log(9.0) * 3.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
    }

    @Test
    public void testBufferAggregate() {
        TestFloatColumnSelector selector1 = new TestFloatColumnSelector(new float[]{42.12f, 9.0f});
        TestFloatColumnSelector selector2 = new TestFloatColumnSelector(new float[]{2.0f, 3.0f});
        Map<String, String> script = SUM_LOG_A_TIMES_B_PLUS_TEN;
        JavaScriptBufferAggregator agg = new JavaScriptBufferAggregator(Arrays.asList(selector1, selector2), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        ByteBuffer buf = ByteBuffer.allocate(32);
        int position = 4;
        agg.init(buf, 4);
        double val = 10.0;
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        this.aggregateBuffer(selector1, selector2, (BufferAggregator)agg, buf, 4);
        Assert.assertEquals((Object)(val += Math.log(42.12f) * 2.0), (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        this.aggregateBuffer(selector1, selector2, (BufferAggregator)agg, buf, 4);
        Assert.assertEquals((Object)(val += Math.log(9.0) * 3.0), (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
    }

    @Test
    public void testAggregateMissingColumn() {
        Map<String, String> script = SCRIPT_DOUBLE_SUM;
        JavaScriptAggregator agg = new JavaScriptAggregator(Collections.singletonList(null), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        double val = 0.0;
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        agg.aggregate();
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        agg.aggregate();
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
    }

    @Test
    public void testAggregateStrings() {
        TestObjectColumnSelector<Object> ocs = new TestObjectColumnSelector<Object>(new Object[]{"what", null, new String[]{"hey", "there"}});
        JavaScriptAggregator agg = new JavaScriptAggregator(Collections.singletonList(ocs), JavaScriptAggregatorFactory.compileScript((String)"function aggregate(current, a) { if (Array.isArray(a)) { return current + a.length; } else if (typeof a === 'string') { return current + 1; } else { return current; } }", (String)SCRIPT_DOUBLE_SUM.get("fnReset"), (String)SCRIPT_DOUBLE_SUM.get("fnCombine")));
        double val = 0.0;
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)(val += 1.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)(val += 2.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
    }

    @Test
    public void testJavaScriptDisabledFactorize() {
        JavaScriptAggregatorFactory factory = new JavaScriptAggregatorFactory("foo", (List)ImmutableList.of((Object)"foo"), SCRIPT_DOUBLE_SUM.get("fnAggregate"), SCRIPT_DOUBLE_SUM.get("fnReset"), SCRIPT_DOUBLE_SUM.get("fnCombine"), new JavaScriptConfig(false));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        factory.factorize(this.DUMMY_COLUMN_SELECTOR_FACTORY);
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testJavaScriptDisabledFactorizeBuffered() {
        JavaScriptAggregatorFactory factory = new JavaScriptAggregatorFactory("foo", (List)ImmutableList.of((Object)"foo"), SCRIPT_DOUBLE_SUM.get("fnAggregate"), SCRIPT_DOUBLE_SUM.get("fnReset"), SCRIPT_DOUBLE_SUM.get("fnCombine"), new JavaScriptConfig(false));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        factory.factorizeBuffered(this.DUMMY_COLUMN_SELECTOR_FACTORY);
        Assert.assertTrue((boolean)false);
    }

    public static void main(String ... args) {
        int i;
        JavaScriptAggregatorBenchmark.LoopingDoubleColumnSelector selector = new JavaScriptAggregatorBenchmark.LoopingDoubleColumnSelector(new double[]{42.12, 9.0});
        Map<String, String> script = SCRIPT_DOUBLE_SUM;
        JavaScriptAggregator aggRhino = new JavaScriptAggregator(Collections.singletonList(selector), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        DoubleSumAggregator doubleAgg = new DoubleSumAggregator((BaseDoubleColumnValueSelector)selector);
        for (i = 0; i < 10000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)aggRhino);
        }
        for (i = 0; i < 10000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)doubleAgg);
        }
        long t = System.currentTimeMillis();
        for (i = 0; i < 500000000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)aggRhino);
        }
        long t1 = System.currentTimeMillis() - t;
        System.out.println(StringUtils.format((String)"JavaScript aggregator == %,f: %d ms", (Object[])new Object[]{Float.valueOf(aggRhino.getFloat()), t1}));
        t = System.currentTimeMillis();
        for (i = 0; i < 500000000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)doubleAgg);
        }
        long t2 = System.currentTimeMillis() - t;
        System.out.println(StringUtils.format((String)"DoubleSum  aggregator == %,f: %d ms", (Object[])new Object[]{Float.valueOf(doubleAgg.getFloat()), t2}));
        System.out.println(StringUtils.format((String)"JavaScript is %2.1fx slower", (Object[])new Object[]{(double)t1 / (double)t2}));
    }

    static {
        SUM_LOG_A_TIMES_B_PLUS_TEN.put("fnAggregate", "function aggregate(current, a, b) { return current + (Math.log(a) * b) }");
        SUM_LOG_A_TIMES_B_PLUS_TEN.put("fnReset", "function reset()                  { return 10 }");
        SUM_LOG_A_TIMES_B_PLUS_TEN.put("fnCombine", "function combine(a,b)             { return a + b }");
        SCRIPT_DOUBLE_SUM.put("fnAggregate", "function aggregate(current, a) { return current + a }");
        SCRIPT_DOUBLE_SUM.put("fnReset", "function reset()               { return 0 }");
        SCRIPT_DOUBLE_SUM.put("fnCombine", "function combine(a,b)          { return a + b }");
    }
}

