/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyVectorAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StringAnyAggregatorFactoryTest
extends InitializedNullHandlingTest {
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final int MAX_STRING_BYTES = 10;
    @Mock
    private ColumnInspector columnInspector;
    @Mock
    private ColumnCapabilities capabilities;
    @Mock
    private VectorColumnSelectorFactory vectorSelectorFactory;
    @Mock
    private SingleValueDimensionVectorSelector singleValueDimensionVectorSelector;
    @Mock
    private MultiValueDimensionVectorSelector multiValueDimensionVectorSelector;
    private StringAnyAggregatorFactory target;

    @Before
    public void setUp() {
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.capabilities).when((Object)this.vectorSelectorFactory)).getColumnCapabilities(FIELD_NAME);
        ((ColumnCapabilities)Mockito.doReturn((Object)ColumnCapabilities.Capable.UNKNOWN).when((Object)this.capabilities)).hasMultipleValues();
        this.target = new StringAnyAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(10));
    }

    @Test
    public void canVectorizeWithoutCapabilitiesShouldReturnTrue() {
        Assert.assertTrue((boolean)this.target.canVectorize(this.columnInspector));
    }

    @Test
    public void factorizeVectorWithoutCapabilitiesShouldReturnAggregatorWithMultiDimensionSelector() {
        ((VectorColumnSelectorFactory)Mockito.doReturn(null).when((Object)this.vectorSelectorFactory)).getColumnCapabilities(FIELD_NAME);
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.singleValueDimensionVectorSelector).when((Object)this.vectorSelectorFactory)).makeSingleValueDimensionSelector((DimensionSpec)ArgumentMatchers.any());
        StringAnyVectorAggregator aggregator = this.target.factorizeVector(this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }

    @Test
    public void factorizeVectorWithUnknownCapabilitiesShouldReturnAggregatorWithMultiDimensionSelector() {
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.multiValueDimensionVectorSelector).when((Object)this.vectorSelectorFactory)).makeMultiValueDimensionSelector((DimensionSpec)ArgumentMatchers.any());
        StringAnyVectorAggregator aggregator = this.target.factorizeVector(this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }

    @Test
    public void factorizeVectorWithMultipleValuesCapabilitiesShouldReturnAggregatorWithMultiDimensionSelector() {
        ((ColumnCapabilities)Mockito.doReturn((Object)ColumnCapabilities.Capable.TRUE).when((Object)this.capabilities)).hasMultipleValues();
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.multiValueDimensionVectorSelector).when((Object)this.vectorSelectorFactory)).makeMultiValueDimensionSelector((DimensionSpec)ArgumentMatchers.any());
        StringAnyVectorAggregator aggregator = this.target.factorizeVector(this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }

    @Test
    public void factorizeVectorWithoutMultipleValuesCapabilitiesShouldReturnAggregatorWithSingleDimensionSelector() {
        ((ColumnCapabilities)Mockito.doReturn((Object)ColumnCapabilities.Capable.FALSE).when((Object)this.capabilities)).hasMultipleValues();
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.singleValueDimensionVectorSelector).when((Object)this.vectorSelectorFactory)).makeSingleValueDimensionSelector((DimensionSpec)ArgumentMatchers.any());
        StringAnyVectorAggregator aggregator = this.target.factorizeVector(this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }
}

