/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import java.util.Comparator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class ConstantPostAggregatorTest {
    @Test
    public void testCompute() {
        ConstantPostAggregator constantPostAggregator = new ConstantPostAggregator("shichi", (Number)7);
        Assert.assertEquals((Object)7, (Object)constantPostAggregator.compute(null));
        constantPostAggregator = new ConstantPostAggregator("rei", (Number)0.0);
        Assert.assertEquals((Object)0.0, (Object)constantPostAggregator.compute(null));
        constantPostAggregator = new ConstantPostAggregator("ichi", (Number)1.0);
        Assert.assertNotSame((Object)1, (Object)constantPostAggregator.compute(null));
    }

    @Test
    public void testComparator() {
        ConstantPostAggregator constantPostAggregator = new ConstantPostAggregator("thistestbasicallydoesnothing unhappyface", (Number)1);
        Comparator comp = constantPostAggregator.getComparator();
        Assert.assertEquals((long)0L, (long)comp.compare(0, constantPostAggregator.compute(null)));
        Assert.assertEquals((long)0L, (long)comp.compare(0, 1));
        Assert.assertEquals((long)0L, (long)comp.compare(1, 0));
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ConstantPostAggregator aggregator = new ConstantPostAggregator("aggregator", (Number)2);
        ConstantPostAggregator aggregator1 = (ConstantPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)aggregator), ConstantPostAggregator.class);
        Assert.assertEquals((Object)aggregator, (Object)aggregator1);
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new ConstantPostAggregator("a", (Number)3L), new ConstantPostAggregator("b", (Number)Float.valueOf(1.0f)), new ConstantPostAggregator("c", (Number)5.0)}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ColumnType.LONG).add("a", ColumnType.LONG).add("b", ColumnType.DOUBLE).add("c", ColumnType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

