/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ResponseContextTest {
    static final ResponseContext.Key EXTN_STRING_KEY = new ResponseContext.StringKey("extn_string_key", true, true);
    static final ResponseContext.Key EXTN_COUNTER_KEY = new ResponseContext.CounterKey("extn_counter_key", true);
    static final ResponseContext.Key UNREGISTERED_KEY;
    private static final Interval INTERVAL_01;
    private static final Interval INTERVAL_12;
    private static final Interval INTERVAL_23;
    private static final int INTERVAL_LEN = 52;

    @Test(expected=IllegalStateException.class)
    public void putISETest() {
        ResponseContext.createEmpty().put(UNREGISTERED_KEY, new Object());
    }

    @Test(expected=IllegalStateException.class)
    public void addISETest() {
        ResponseContext.createEmpty().add(UNREGISTERED_KEY, new Object());
    }

    @Test(expected=IllegalArgumentException.class)
    public void registerKeyIAETest() {
        ResponseContext.Keys.INSTANCE.registerKey(ResponseContext.Keys.NUM_SCANNED_ROWS);
    }

    @Test
    public void mergeETagTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.putEntityTag("dummy-etag");
        Assert.assertEquals((Object)"dummy-etag", (Object)ctx.getEntityTag());
        ctx.putEntityTag("new-dummy-etag");
        Assert.assertEquals((Object)"new-dummy-etag", (Object)ctx.getEntityTag());
    }

    @Test
    public void mergeUncoveredIntervalsTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.putUncoveredIntervals(Collections.singletonList(INTERVAL_01), false);
        Assert.assertArrayEquals((Object[])Collections.singletonList(INTERVAL_01).toArray(), (Object[])ctx.getUncoveredIntervals().toArray());
        ctx.add(ResponseContext.Keys.UNCOVERED_INTERVALS, Arrays.asList(INTERVAL_12, INTERVAL_23));
        Assert.assertArrayEquals((Object[])Arrays.asList(INTERVAL_01, INTERVAL_12, INTERVAL_23).toArray(), (Object[])ctx.getUncoveredIntervals().toArray());
    }

    @Test
    public void mergeRemainingResponseTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        String queryId = "queryId";
        String queryId2 = "queryId2";
        ctx.initialize();
        ctx.addRemainingResponse("queryId", 3);
        ctx.addRemainingResponse("queryId2", 4);
        ctx.addRemainingResponse("queryId", -1);
        ctx.addRemainingResponse("queryId", -2);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)0, (Object)"queryId2", (Object)4), (Object)ctx.get(ResponseContext.Keys.REMAINING_RESPONSES_FROM_QUERY_SERVERS));
    }

    @Test
    public void mergeMissingSegmentsTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        SegmentDescriptor sd01 = new SegmentDescriptor(INTERVAL_01, "01", 0);
        ctx.addMissingSegments(Collections.singletonList(sd01));
        Assert.assertArrayEquals((Object[])Collections.singletonList(sd01).toArray(), (Object[])ctx.getMissingSegments().toArray());
        SegmentDescriptor sd12 = new SegmentDescriptor(INTERVAL_12, "12", 1);
        SegmentDescriptor sd23 = new SegmentDescriptor(INTERVAL_23, "23", 2);
        ctx.addMissingSegments(Arrays.asList(sd12, sd23));
        Assert.assertArrayEquals((Object[])Arrays.asList(sd01, sd12, sd23).toArray(), (Object[])ctx.getMissingSegments().toArray());
    }

    @Test
    public void initScannedRowsTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        Assert.assertNull((Object)ctx.getRowScanCount());
        ctx.initializeRowScanCount();
        Assert.assertEquals((Object)0L, (Object)ctx.getRowScanCount());
    }

    @Test
    public void mergeScannedRowsTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        Assert.assertNull((Object)ctx.getRowScanCount());
        ctx.addRowScanCount(0L);
        Assert.assertEquals((Object)0L, (Object)ctx.getRowScanCount());
        ctx.addRowScanCount(1L);
        Assert.assertEquals((Object)1L, (Object)ctx.getRowScanCount());
        ctx.addRowScanCount(3L);
        Assert.assertEquals((Object)4L, (Object)ctx.getRowScanCount());
    }

    @Test
    public void mergeUncoveredIntervalsOverflowedTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.add(ResponseContext.Keys.UNCOVERED_INTERVALS_OVERFLOWED, (Object)false);
        Assert.assertEquals((Object)false, (Object)ctx.get(ResponseContext.Keys.UNCOVERED_INTERVALS_OVERFLOWED));
        ctx.add(ResponseContext.Keys.UNCOVERED_INTERVALS_OVERFLOWED, (Object)true);
        Assert.assertEquals((Object)true, (Object)ctx.get(ResponseContext.Keys.UNCOVERED_INTERVALS_OVERFLOWED));
        ctx.add(ResponseContext.Keys.UNCOVERED_INTERVALS_OVERFLOWED, (Object)false);
        Assert.assertEquals((Object)true, (Object)ctx.get(ResponseContext.Keys.UNCOVERED_INTERVALS_OVERFLOWED));
    }

    @Test
    public void mergeResponseContextTest() {
        ResponseContext ctx1 = ResponseContext.createEmpty();
        ctx1.putEntityTag("dummy-etag-1");
        ctx1.putUncoveredIntervals(Collections.singletonList(INTERVAL_01), false);
        ctx1.addRowScanCount(1L);
        ResponseContext ctx2 = ResponseContext.createEmpty();
        ctx2.putEntityTag("dummy-etag-2");
        ctx2.putUncoveredIntervals(Collections.singletonList(INTERVAL_12), false);
        SegmentDescriptor sd01 = new SegmentDescriptor(INTERVAL_01, "01", 0);
        ctx2.addMissingSegments(Collections.singletonList(sd01));
        ctx2.addRowScanCount(2L);
        ctx1.merge(ctx2);
        Assert.assertEquals((Object)"dummy-etag-2", (Object)ctx1.getEntityTag());
        Assert.assertEquals((Object)3L, (Object)ctx1.getRowScanCount());
        Assert.assertArrayEquals((Object[])Arrays.asList(INTERVAL_01, INTERVAL_12).toArray(), (Object[])ctx1.getUncoveredIntervals().toArray());
        Assert.assertArrayEquals((Object[])Collections.singletonList(sd01).toArray(), (Object[])ctx1.getMissingSegments().toArray());
    }

    @Test(expected=IllegalStateException.class)
    public void mergeISETest() {
        ResponseContext ctx = new ResponseContext(){

            protected Map<ResponseContext.Key, Object> getDelegate() {
                return ImmutableMap.of((Object)UNREGISTERED_KEY, (Object)"non-registered-key");
            }
        };
        ResponseContext.createEmpty().merge(ctx);
    }

    @Test
    public void serializeWithCorrectnessTest() throws JsonProcessingException {
        ResponseContext ctx1 = ResponseContext.createEmpty();
        ctx1.add(EXTN_STRING_KEY, (Object)"string-value");
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)ImmutableMap.of((Object)EXTN_STRING_KEY.getName(), (Object)"string-value")), (Object)ctx1.serializeWith((ObjectMapper)mapper, Integer.MAX_VALUE).getResult());
        ResponseContext ctx2 = ResponseContext.createEmpty();
        ctx2.putEntityTag("not in header");
        ctx2.addCpuNanos(100L);
        ctx2.add(EXTN_COUNTER_KEY, (Object)100);
        Assert.assertEquals((Object)mapper.writeValueAsString((Object)ImmutableMap.of((Object)EXTN_COUNTER_KEY.getName(), (Object)100)), (Object)ctx2.serializeWith((ObjectMapper)mapper, Integer.MAX_VALUE).getResult());
    }

    private Map<ResponseContext.Key, Object> deserializeContext(String input, ObjectMapper mapper) throws IOException {
        return ResponseContext.deserialize((String)input, (ObjectMapper)mapper).getDelegate();
    }

    @Test
    public void serializeWithTruncateValueTest() throws IOException {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.put(EXTN_COUNTER_KEY, (Object)100L);
        ctx.put(EXTN_STRING_KEY, (Object)"long-string-that-is-supposed-to-be-removed-from-result");
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        ResponseContext.SerializationResult res1 = ctx.serializeWith((ObjectMapper)objectMapper, Integer.MAX_VALUE);
        Assert.assertEquals((Object)ctx.getDelegate(), this.deserializeContext(res1.getResult(), (ObjectMapper)objectMapper));
        ResponseContext ctxCopy = ResponseContext.createEmpty();
        ctxCopy.merge(ctx);
        int target = EXTN_COUNTER_KEY.getName().length() + 3 + ResponseContext.Keys.TRUNCATED.getName().length() + 5 + 15;
        ResponseContext.SerializationResult res2 = ctx.serializeWith((ObjectMapper)objectMapper, target);
        ctxCopy.remove(EXTN_STRING_KEY);
        ctxCopy.put(ResponseContext.Keys.TRUNCATED, (Object)true);
        Assert.assertEquals((Object)ctxCopy.getDelegate(), this.deserializeContext(res2.getResult(), (ObjectMapper)objectMapper));
    }

    @Test
    public void deserializeWithUnknownKeyTest() throws IOException {
        HashMap<String, Object> bogus = new HashMap<String, Object>();
        bogus.put(ResponseContext.Keys.ETAG.getName(), "eTag");
        bogus.put("scalar", "doomed");
        bogus.put("array", new String[]{"foo", "bar"});
        HashMap<String, String[]> objValue = new HashMap<String, String[]>();
        objValue.put("array", new String[]{"foo", "bar"});
        bogus.put("obj", objValue);
        bogus.put("null", null);
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String serialized = mapper.writeValueAsString(bogus);
        ResponseContext ctx = ResponseContext.deserialize((String)serialized, (ObjectMapper)mapper);
        Assert.assertEquals((long)1L, (long)ctx.getDelegate().size());
        Assert.assertEquals((Object)"eTag", (Object)ctx.get(ResponseContext.Keys.ETAG));
    }

    private static Interval interval(int n) {
        return Intervals.of((String)StringUtils.format((String)"2021-01-%02d/PT1M", (Object[])new Object[]{n}));
    }

    @Test
    public void serializeWithTruncateArrayTest() throws IOException {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.put(ResponseContext.Keys.UNCOVERED_INTERVALS, Arrays.asList(ResponseContextTest.interval(1), ResponseContextTest.interval(2), ResponseContextTest.interval(3), ResponseContextTest.interval(4), ResponseContextTest.interval(5), ResponseContextTest.interval(6)));
        ctx.put(EXTN_STRING_KEY, (Object)Strings.repeat((String)"x", (int)364));
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        ResponseContext.SerializationResult res1 = ctx.serializeWith((ObjectMapper)objectMapper, Integer.MAX_VALUE);
        Assert.assertEquals((Object)ctx.getDelegate(), this.deserializeContext(res1.getResult(), (ObjectMapper)objectMapper));
        int maxLen = 208 + ResponseContext.Keys.UNCOVERED_INTERVALS.getName().length() + 4 + ResponseContext.Keys.TRUNCATED.getName().length() + 6;
        ResponseContext.SerializationResult res2 = ctx.serializeWith((ObjectMapper)objectMapper, maxLen);
        ResponseContext ctxCopy = ResponseContext.createEmpty();
        ctxCopy.put(ResponseContext.Keys.UNCOVERED_INTERVALS, Arrays.asList(ResponseContextTest.interval(1), ResponseContextTest.interval(2), ResponseContextTest.interval(3)));
        ctxCopy.put(ResponseContext.Keys.TRUNCATED, (Object)true);
        Assert.assertEquals((Object)ctxCopy.getDelegate(), this.deserializeContext(res2.getResult(), (ObjectMapper)objectMapper));
    }

    @Test
    public void deserializeTest() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ResponseContext ctx = ResponseContext.deserialize((String)mapper.writeValueAsString((Object)ImmutableMap.of((Object)ResponseContext.Keys.ETAG.getName(), (Object)"string-value", (Object)ResponseContext.Keys.NUM_SCANNED_ROWS.getName(), (Object)100L, (Object)ResponseContext.Keys.CPU_CONSUMED_NANOS.getName(), (Object)100000L)), (ObjectMapper)mapper);
        Assert.assertEquals((Object)"string-value", (Object)ctx.getEntityTag());
        Assert.assertEquals((Object)100L, (Object)ctx.getRowScanCount());
        Assert.assertEquals((Object)100000L, (Object)ctx.getCpuNanos());
        ctx.addRowScanCount(10L);
        Assert.assertEquals((Object)110L, (Object)ctx.getRowScanCount());
        ctx.addCpuNanos(100L);
        Assert.assertEquals((Object)100100L, (Object)ctx.getCpuNanos());
    }

    @Test
    public void extensionEnumMergeTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.putEntityTag("etag");
        ctx.add(EXTN_STRING_KEY, (Object)"string-value");
        ctx.add(EXTN_COUNTER_KEY, (Object)2L);
        ResponseContext ctxFinal = ResponseContext.createEmpty();
        ctxFinal.putEntityTag("old-etag");
        ctxFinal.add(EXTN_STRING_KEY, (Object)"old-string-value");
        ctxFinal.add(EXTN_COUNTER_KEY, (Object)1L);
        ctxFinal.merge(ctx);
        Assert.assertEquals((Object)"etag", (Object)ctxFinal.getEntityTag());
        Assert.assertEquals((Object)"string-value", (Object)ctxFinal.get(EXTN_STRING_KEY));
        Assert.assertEquals((Object)3L, (Object)ctxFinal.get(EXTN_COUNTER_KEY));
    }

    @Test
    public void toMapTest() {
        ResponseContext ctx = ResponseContext.createEmpty();
        ctx.putEntityTag("etag");
        Map map = ctx.toMap();
        Assert.assertEquals(map.get(ResponseContext.Keys.ETAG.getName()), (Object)"etag");
    }

    static {
        ResponseContext.Keys.instance().registerKeys(new ResponseContext.Key[]{EXTN_STRING_KEY, EXTN_COUNTER_KEY});
        UNREGISTERED_KEY = new ResponseContext.StringKey("unregistered-key", true, true);
        INTERVAL_01 = Intervals.of((String)"2019-01-01/P1D");
        INTERVAL_12 = Intervals.of((String)"2019-01-02/P1D");
        INTERVAL_23 = Intervals.of((String)"2019-01-03/P1D");
    }
}

