/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ForwardingFilteredDimensionSelector;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.query.dimension.PredicateFilteredDimensionSelector;
import org.apache.druid.query.dimension.StringDimensionSelectorForTest;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ListFilteredDimensionSpecDimensionSelectorTest
extends InitializedNullHandlingTest {
    private final ListFilteredDimensionSpec targetWithAllowList = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"val1_1", (Object)"val2_2", (Object)"val2_3"), Boolean.valueOf(true));
    private final ListFilteredDimensionSpec targetWithDenyList = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), (Set)ImmutableSet.of((Object)"val1_1", (Object)"val2_2", (Object)"val2_3"), Boolean.valueOf(false));
    private final List<List<String>> data = ImmutableList.of((Object)ImmutableList.of((Object)"val1_1", (Object)"val1_2"), (Object)ImmutableList.of((Object)"val2_1", (Object)"val2_2", (Object)"val2_3"), (Object)ImmutableList.of((Object)"val3_1"));

    @Test
    public void testNullDimensionSelectorReturnNull() {
        Assert.assertNull((Object)this.targetWithAllowList.decorate((DimensionSelector)null));
        Assert.assertNull((Object)this.targetWithDenyList.decorate((DimensionSelector)null));
    }

    @Test
    public void testAllowListWhenDictionaryLookupIsAvailable() {
        this.testAllowList(false, true, true, ForwardingFilteredDimensionSelector.class);
    }

    @Test
    public void testAllowListWhenIdLookupIsNotAvailable() {
        this.testAllowList(false, false, true, ForwardingFilteredDimensionSelector.class);
    }

    @Test
    public void testAllowListWhenCardinalityIsUnknown() {
        this.testAllowList(true, true, true, PredicateFilteredDimensionSelector.class);
    }

    @Test
    public void testAllowListWhenNameLookupIsNotPossibleInAdvance() {
        this.testAllowList(false, true, false, PredicateFilteredDimensionSelector.class);
    }

    @Test
    public void testDenyListWhenDictionaryLookupIsAvailable() {
        this.testDenyList(false, true, true, ForwardingFilteredDimensionSelector.class);
    }

    @Test
    public void testDenyListWhenIdLookupIsNotAvailable() {
        this.testDenyList(false, false, true, ForwardingFilteredDimensionSelector.class);
    }

    @Test
    public void testDenyListWhenCardinalityIsUnknown() {
        this.testDenyList(true, true, true, PredicateFilteredDimensionSelector.class);
    }

    @Test
    public void testDenyListWhenNameLookupIsNotPossibleInAdvance() {
        this.testDenyList(false, true, false, PredicateFilteredDimensionSelector.class);
    }

    private void testAllowList(boolean unknownCardinality, boolean validIdLookup, boolean nameLookupPossibleInAdvance, Class<? extends DimensionSelector> expectedDimensionSelectorClass) {
        RowSupplier rowSupplier = new RowSupplier();
        NonnullPair<Object2IntMap<String>, Int2ObjectMap<String>> dictionaries = this.createDictionaries(this.data);
        DimensionSelector selector = this.targetWithAllowList.decorate((DimensionSelector)new StringDimensionSelectorForTest(rowSupplier, (Object2IntMap<String>)((Object2IntMap)dictionaries.lhs), (Int2ObjectMap<String>)((Int2ObjectMap)dictionaries.rhs), unknownCardinality, validIdLookup, nameLookupPossibleInAdvance));
        Assert.assertSame(expectedDimensionSelectorClass, selector.getClass());
        this.assertAllowListFiltering(rowSupplier, selector);
    }

    private void testDenyList(boolean unknownCardinality, boolean validIdLookup, boolean nameLookupPossibleInAdvance, Class<? extends DimensionSelector> expectedDimensionSelectorClass) {
        RowSupplier rowSupplier = new RowSupplier();
        NonnullPair<Object2IntMap<String>, Int2ObjectMap<String>> dictionaries = this.createDictionaries(this.data);
        DimensionSelector selector = this.targetWithDenyList.decorate((DimensionSelector)new StringDimensionSelectorForTest(rowSupplier, (Object2IntMap<String>)((Object2IntMap)dictionaries.lhs), (Int2ObjectMap<String>)((Int2ObjectMap)dictionaries.rhs), unknownCardinality, validIdLookup, nameLookupPossibleInAdvance));
        Assert.assertSame(expectedDimensionSelectorClass, selector.getClass());
        this.assertDenyListFiltering(rowSupplier, selector);
    }

    private NonnullPair<Object2IntMap<String>, Int2ObjectMap<String>> createDictionaries(List<List<String>> values) {
        Object2IntOpenHashMap dictionary = new Object2IntOpenHashMap();
        Int2ObjectOpenHashMap reverseDictionary = new Int2ObjectOpenHashMap();
        MutableInt nextId = new MutableInt(0);
        for (List<String> multiValue : values) {
            for (String value : multiValue) {
                int dictId = dictionary.computeIntIfAbsent((Object)value, k -> nextId.getAndIncrement());
                reverseDictionary.putIfAbsent(dictId, (Object)value);
            }
        }
        return new NonnullPair((Object)dictionary, (Object)reverseDictionary);
    }

    private void assertAllowListFiltering(RowSupplier rowSupplier, DimensionSelector selector) {
        rowSupplier.set(this.data.get(0));
        IndexedInts encodedRow = selector.getRow();
        Assert.assertEquals((long)1L, (long)encodedRow.size());
        Assert.assertEquals((Object)"val1_1", (Object)selector.lookupName(encodedRow.get(0)));
        rowSupplier.set(this.data.get(1));
        encodedRow = selector.getRow();
        Assert.assertEquals((long)2L, (long)encodedRow.size());
        Assert.assertEquals((Object)"val2_2", (Object)selector.lookupName(encodedRow.get(0)));
        Assert.assertEquals((Object)"val2_3", (Object)selector.lookupName(encodedRow.get(1)));
        rowSupplier.set(this.data.get(2));
        encodedRow = selector.getRow();
        Assert.assertEquals((long)0L, (long)encodedRow.size());
    }

    private void assertDenyListFiltering(RowSupplier rowSupplier, DimensionSelector selector) {
        rowSupplier.set(this.data.get(0));
        IndexedInts encodedRow = selector.getRow();
        Assert.assertEquals((long)1L, (long)encodedRow.size());
        Assert.assertEquals((Object)"val1_2", (Object)selector.lookupName(encodedRow.get(0)));
        rowSupplier.set(this.data.get(1));
        encodedRow = selector.getRow();
        Assert.assertEquals((long)1L, (long)encodedRow.size());
        Assert.assertEquals((Object)"val2_1", (Object)selector.lookupName(encodedRow.get(0)));
        rowSupplier.set(this.data.get(2));
        encodedRow = selector.getRow();
        Assert.assertEquals((long)1L, (long)encodedRow.size());
        Assert.assertEquals((Object)"val3_1", (Object)selector.lookupName(encodedRow.get(0)));
    }

    private static class RowSupplier
    implements Supplier<List<String>> {
        private List<String> row;

        private RowSupplier() {
        }

        public void set(List<String> row) {
            this.row = row;
        }

        @Override
        public List<String> get() {
            return this.row;
        }
    }
}

