/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.CaseInsensitiveContainsExprMacro;
import org.apache.druid.query.expression.MacroTestBase;
import org.junit.Assert;
import org.junit.Test;

public class CaseInsensitiveExprMacroTest
extends MacroTestBase {
    public CaseInsensitiveExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new CaseInsensitiveContainsExprMacro());
    }

    @Test
    public void testErrorZeroArguments() {
        this.expectException(IllegalArgumentException.class, "Function[icontains_string] requires 2 arguments");
        this.eval("icontains_string()", InputBindings.withMap((Map)ImmutableMap.of()));
    }

    @Test
    public void testErrorThreeArguments() {
        this.expectException(IllegalArgumentException.class, "Function[icontains_string] requires 2 arguments");
        this.eval("icontains_string('a', 'b', 'c')", InputBindings.withMap((Map)ImmutableMap.of()));
    }

    @Test
    public void testMatchSearchLowerCase() {
        ExprEval<?> result = this.eval("icontains_string(a, 'OBA')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foobar")));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testMatchSearchUpperCase() {
        ExprEval<?> result = this.eval("icontains_string(a, 'oba')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"FOOBAR")));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNoMatch() {
        ExprEval<?> result = this.eval("icontains_string(a, 'bar')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)false).value(), (Object)result.value());
    }

    @Test
    public void testNullSearch() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[icontains_string] substring must be a string literal");
        }
        ExprEval<?> result = this.eval("icontains_string(a, null)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringSearch() {
        ExprEval<?> result = this.eval("icontains_string(a, '')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"foo")));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNullSearchOnEmptyString() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[icontains_string] substring must be a string literal");
        }
        ExprEval<?> result = this.eval("icontains_string(a, null)", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"")));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringSearchOnEmptyString() {
        ExprEval<?> result = this.eval("icontains_string(a, '')", InputBindings.withMap((Map)ImmutableMap.of((Object)"a", (Object)"")));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNullSearchOnNull() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[icontains_string] substring must be a string literal");
        }
        ExprEval<?> result = this.eval("icontains_string(a, null)", InputBindings.nilBindings());
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringSearchOnNull() {
        ExprEval<?> result = this.eval("icontains_string(a, '')", InputBindings.nilBindings());
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((!NullHandling.sqlCompatible() ? 1 : 0) != 0).value(), (Object)result.value());
    }
}

