/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.HyperUniqueExpressions;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HyperUniqueExpressionsTest
extends InitializedNullHandlingTest {
    private static final ExprMacroTable MACRO_TABLE = new ExprMacroTable((List)ImmutableList.of((Object)new HyperUniqueExpressions.HllCreateExprMacro(), (Object)new HyperUniqueExpressions.HllAddExprMacro(), (Object)new HyperUniqueExpressions.HllEstimateExprMacro(), (Object)new HyperUniqueExpressions.HllRoundEstimateExprMacro()));
    private static final String SOME_STRING = "foo";
    private static final long SOME_LONG = 1234L;
    private static final double SOME_DOUBLE = 1.234;
    Expr.ObjectBinding inputBindings = InputBindings.withTypedSuppliers((Map)new ImmutableMap.Builder().put((Object)"hll", (Object)new Pair((Object)HyperUniqueExpressions.TYPE, HyperLogLogCollector::makeLatestCollector)).put((Object)"string", (Object)new Pair((Object)ExpressionType.STRING, () -> "foo")).put((Object)"long", (Object)new Pair((Object)ExpressionType.LONG, () -> 1234L)).put((Object)"double", (Object)new Pair((Object)ExpressionType.DOUBLE, () -> 1.234)).put((Object)"nullString", (Object)new Pair((Object)ExpressionType.STRING, () -> null)).put((Object)"nullLong", (Object)new Pair((Object)ExpressionType.LONG, () -> null)).put((Object)"nullDouble", (Object)new Pair((Object)ExpressionType.DOUBLE, () -> null)).build());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCreate() {
        Expr expr = Parser.parse((String)"hyper_unique()", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)0.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.0);
    }

    @Test
    public void testString() {
        Expr expr = Parser.parse((String)"hyper_unique_add('foo', hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add('bar', hyper_unique_add('foo', hyper_unique()))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)2.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(string, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(nullString, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 1.0 : 0.0), (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
    }

    @Test
    public void testLong() {
        Expr expr = Parser.parse((String)"hyper_unique_add(1234, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(1234, hyper_unique_add(5678, hyper_unique()))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)2.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(long, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(nullLong, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 1.0 : 0.0), (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
    }

    @Test
    public void testDouble() {
        Expr expr = Parser.parse((String)"hyper_unique_add(1.234, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(1.234, hyper_unique_add(5.678, hyper_unique()))", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)2.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(double, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
        expr = Parser.parse((String)"hyper_unique_add(nullDouble, hyper_unique())", (ExprMacroTable)MACRO_TABLE);
        eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)HyperUniqueExpressions.TYPE, (Object)eval.type());
        Assert.assertTrue((boolean)(eval.value() instanceof HyperLogLogCollector));
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 1.0 : 0.0), (double)((HyperLogLogCollector)eval.value()).estimateCardinality(), (double)0.01);
    }

    @Test
    public void testEstimate() {
        Expr expr = Parser.parse((String)"hyper_unique_estimate(hyper_unique_add(1.234, hyper_unique()))", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.type());
        Assert.assertEquals((double)1.0, (double)eval.asDouble(), (double)0.01);
    }

    @Test
    public void testEstimateRound() {
        Expr expr = Parser.parse((String)"hyper_unique_round_estimate(hyper_unique_add(1.234, hyper_unique()))", (ExprMacroTable)MACRO_TABLE);
        ExprEval eval = expr.eval(this.inputBindings);
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.type());
        Assert.assertEquals((double)1.0, (double)eval.asLong(), (double)0.01);
    }

    @Test
    public void testCreateWrongArgsCount() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Function[hyper_unique] does not accept arguments");
        Parser.parse((String)"hyper_unique(100)", (ExprMacroTable)MACRO_TABLE);
    }

    @Test
    public void testAddWrongArgsCount() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Function[hyper_unique_add] requires 2 arguments");
        Parser.parse((String)"hyper_unique_add(100, hyper_unique(), 100)", (ExprMacroTable)MACRO_TABLE);
    }

    @Test
    public void testAddWrongArgType() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Function[hyper_unique_add] requires a hyper-log-log collector as the second argument");
        Expr expr = Parser.parse((String)"hyper_unique_add(long, string)", (ExprMacroTable)MACRO_TABLE);
        expr.eval(this.inputBindings);
    }

    @Test
    public void testEstimateWrongArgsCount() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Function[hyper_unique_estimate] requires 1 argument");
        Parser.parse((String)"hyper_unique_estimate(hyper_unique(), 100)", (ExprMacroTable)MACRO_TABLE);
    }

    @Test
    public void testEstimateWrongArgTypes() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Function[hyper_unique_estimate] requires a hyper-log-log collector as input");
        Expr expr = Parser.parse((String)"hyper_unique_estimate(100)", (ExprMacroTable)MACRO_TABLE);
        expr.eval(this.inputBindings);
    }

    @Test
    public void testRoundEstimateWrongArgsCount() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Function[hyper_unique_round_estimate] requires 1 argument");
        Parser.parse((String)"hyper_unique_round_estimate(hyper_unique(), 100)", (ExprMacroTable)MACRO_TABLE);
    }

    @Test
    public void testRoundEstimateWrongArgTypes() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Function[hyper_unique_round_estimate] requires a hyper-log-log collector as input");
        Expr expr = Parser.parse((String)"hyper_unique_round_estimate(string)", (ExprMacroTable)MACRO_TABLE);
        expr.eval(this.inputBindings);
    }
}

