/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.ipv4.IPv4Address;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.query.expression.IPv4AddressExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class IPv4AddressExprUtilsTest {
    private static final List<String> VALID_IPV4_ADDRESSES = Arrays.asList("192.168.0.1", "0.0.0.0", "255.255.255.255", "255.0.0.0", "0.255.0.0", "0.0.255.0", "0.0.0.255");
    private static final List<String> INVALID_IPV4_ADDRESSES = Arrays.asList("druid.apache.org", "a.b.c.d", "abc.def.ghi.jkl", "1..3.4", "1.2..4", "1.2.3..", "1", "1.2", "1.2.3", "1.2.3.4.5", "256.0.0.0", "0.265.0.0", "0.0.266.0", "0.0.0.355", "a.2.3.4", "1.a.3.4", "1.2.c.4", "1.2.3.d", "1.2.3.0/24");
    private static final String IPV6_MAPPED = "::ffff:192.168.0.1";
    private static final String IPV6_COMPATIBLE = "::192.168.0.1";
    private static final List<String> VALID_IPV4_SUBNETS = Arrays.asList("1.1.1.0/24", "255.255.255.0/18", "1.2.3.0/21", "1.0.0.0/8");
    private static final List<String> INVALID_IPV4_SUBNETS = Arrays.asList("1.2.3.0/45", "1.1.1/24", "1/24", "1", "::/23", "1.1.1.1");

    @Test
    public void testOverflowsUnsignedIntTooLow() {
        Assert.assertTrue((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)-1L));
    }

    @Test
    public void testOverflowsUnsignedIntLowest() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)0L));
    }

    @Test
    public void testOverflowsUnsignedIntMiddle() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)65535L));
    }

    @Test
    public void testOverflowsUnsignedIntHighest() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)0xFFFFFFFFL));
    }

    @Test
    public void testOverflowsUnsignedIntTooHigh() {
        Assert.assertTrue((boolean)IPv4AddressExprUtils.overflowsUnsignedInt((long)0x100000000L));
    }

    @Test
    public void testIsValidIPv4AddressNull() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.isValidIPv4Address(null));
    }

    @Test
    public void testIsValidIPv4Address() {
        for (String address : VALID_IPV4_ADDRESSES) {
            Assert.assertTrue((String)this.getErrMsg(address), (boolean)IPv4AddressExprUtils.isValidIPv4Address((String)address));
        }
    }

    @Test
    public void testIsValidIPv4AddressIPv6Mapped() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.isValidIPv4Address((String)IPV6_MAPPED));
    }

    @Test
    public void testIsValidIPv4AddressIPv6Compatible() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.isValidIPv4Address((String)IPV6_COMPATIBLE));
    }

    @Test
    public void testIsValidIPv4AddressNotIpAddress() {
        for (String address : INVALID_IPV4_ADDRESSES) {
            Assert.assertFalse((String)this.getErrMsg(address), (boolean)IPv4AddressExprUtils.isValidIPv4Address((String)address));
        }
    }

    @Test
    public void testIsValidSubnetNull() {
        Assert.assertFalse((boolean)IPv4AddressExprUtils.isValidIPv4Subnet(null));
    }

    @Test
    public void testIsValidIPv4SubnetValid() {
        for (String address : VALID_IPV4_SUBNETS) {
            Assert.assertTrue((String)this.getErrMsg(address), (boolean)IPv4AddressExprUtils.isValidIPv4Subnet((String)address));
        }
    }

    @Test
    public void testIsValidIPv4SubnetInvalid() {
        for (String address : INVALID_IPV4_SUBNETS) {
            Assert.assertFalse((String)this.getErrMsg(address), (boolean)IPv4AddressExprUtils.isValidIPv4Subnet((String)address));
        }
    }

    @Test
    public void testParseNull() {
        Assert.assertNull((Object)IPv4AddressExprUtils.parse(null));
    }

    @Test
    public void testParseIPv4() {
        for (String string : VALID_IPV4_ADDRESSES) {
            String errMsg = this.getErrMsg(string);
            IPv4Address address = IPv4AddressExprUtils.parse((String)string);
            Assert.assertNotNull((String)errMsg, (Object)address);
            Assert.assertEquals((String)errMsg, (Object)string, (Object)address.toString());
        }
    }

    @Test
    public void testParseIPv6Mapped() {
        Assert.assertNull((Object)IPv4AddressExprUtils.parse((String)IPV6_MAPPED));
    }

    @Test
    public void testParseIPv6Compatible() {
        Assert.assertNull((Object)IPv4AddressExprUtils.parse((String)IPV6_COMPATIBLE));
    }

    @Test
    public void testParseNotIpAddress() {
        for (String address : INVALID_IPV4_ADDRESSES) {
            Assert.assertNull((String)this.getErrMsg(address), (Object)IPv4AddressExprUtils.parse((String)address));
        }
    }

    @Test
    public void testParseLong() {
        IPv4Address address = IPv4AddressExprUtils.parse((long)3232235521L);
        Assert.assertNotNull((Object)address);
        Assert.assertArrayEquals((byte[])new byte[]{-64, -88, 0, 1}, (byte[])address.getBytes());
    }

    @Test
    public void testToString() {
        byte[] bytes = new byte[]{-64, -88, 0, 1};
        IPAddressNetwork.IPAddressGenerator generator = new IPAddressNetwork.IPAddressGenerator();
        IPv4Address iPv4Address = generator.from(bytes).toIPv4();
        Assert.assertEquals((Object)"192.168.0.1", (Object)IPv4AddressExprUtils.toString((IPv4Address)iPv4Address));
    }

    @Test
    public void testToLong() {
        byte[] bytes = new byte[]{-64, -88, 0, 1};
        IPAddressNetwork.IPAddressGenerator generator = new IPAddressNetwork.IPAddressGenerator();
        IPv4Address iPv4Address = generator.from(bytes).toIPv4();
        Assert.assertEquals((long)3232235521L, (long)IPv4AddressExprUtils.toLong((IPv4Address)iPv4Address));
    }

    private String getErrMsg(String msg) {
        String prefix = "Failed: ";
        return prefix + msg;
    }
}

