/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.IPv4AddressParseExprMacro;
import org.apache.druid.query.expression.MacroTestBase;
import org.junit.Assert;
import org.junit.Test;

public class IPv4AddressParseExprMacroTest
extends MacroTestBase {
    private static final Expr VALID = ExprEval.of((String)"192.168.0.1").toExpr();
    private static final long EXPECTED = 3232235521L;
    private static final Long NULL = NullHandling.replaceWithDefault() ? NullHandling.ZERO_LONG : null;

    public IPv4AddressParseExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new IPv4AddressParseExprMacro());
    }

    @Test
    public void testTooFewArgs() {
        this.expectException(IllegalArgumentException.class, "requires 1 argument");
        this.apply(Collections.emptyList());
    }

    @Test
    public void testTooManyArgs() {
        this.expectException(IllegalArgumentException.class, "requires 1 argument");
        this.apply(Arrays.asList(VALID, VALID));
    }

    @Test
    public void testNullStringArg() {
        Expr nullString = ExprEval.of(null).toExpr();
        Assert.assertSame((Object)NULL, (Object)this.eval(nullString));
    }

    @Test
    public void testNullLongArg() {
        Expr nullLong = ExprEval.ofLong(null).toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(nullLong));
    }

    @Test
    public void testInvalidArgType() {
        Expr longArray = ExprEval.ofLongArray((Object[])new Long[]{1L, 2L}).toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(longArray));
    }

    @Test
    public void testInvalidStringArgNotIPAddress() {
        Expr notIpAddress = ExprEval.of((String)"druid.apache.org").toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(notIpAddress));
    }

    @Test
    public void testInvalidStringArgIPv6Compatible() {
        Expr ipv6Compatible = ExprEval.of((String)"::192.168.0.1").toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(ipv6Compatible));
    }

    @Test
    public void testValidStringArgIPv6Mapped() {
        Expr ipv6Mapped = ExprEval.of((String)"::ffff:192.168.0.1").toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(ipv6Mapped));
    }

    @Test
    public void testValidStringArgIPv4() {
        Assert.assertEquals((Object)3232235521L, (Object)this.eval(VALID));
    }

    @Test
    public void testValidStringArgUnsignedInt() {
        Expr unsignedInt = ExprEval.of((String)"3232235521").toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(unsignedInt));
    }

    @Test
    public void testInvalidLongArgTooLow() {
        Expr tooLow = ExprEval.ofLong((Number)-1L).toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(tooLow));
    }

    @Test
    public void testValidLongArgLowest() {
        long lowest = 0L;
        Expr tooLow = ExprEval.ofLong((Number)lowest).toExpr();
        Assert.assertEquals((Object)lowest, (Object)this.eval(tooLow));
    }

    @Test
    public void testValidLongArgHighest() {
        long highest = 0xFFFFFFFFL;
        Expr tooLow = ExprEval.ofLong((Number)highest).toExpr();
        Assert.assertEquals((Object)highest, (Object)this.eval(tooLow));
    }

    @Test
    public void testInvalidLongArgTooHigh() {
        Expr tooHigh = ExprEval.ofLong((Number)0x100000000L).toExpr();
        Assert.assertEquals((Object)NULL, (Object)this.eval(tooHigh));
    }

    @Test
    public void testValidLongArg() {
        long value = 3232235521L;
        Expr valid = ExprEval.ofLong((Number)value).toExpr();
        Assert.assertEquals((Object)value, (Object)this.eval(valid));
    }

    private Object eval(Expr arg) {
        Expr expr = this.apply(Collections.singletonList(arg));
        ExprEval eval = expr.eval(InputBindings.nilBindings());
        return eval.value();
    }
}

