/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapLookupExtractorTest {
    private final Map<String, String> lookupMap = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"null", (Object)"", (Object)"empty String", (Object)"", (Object)"", (Object)"empty_string");
    private final MapLookupExtractor fn = new MapLookupExtractor(this.lookupMap, false);

    @BeforeClass
    public static void setUpClass() {
        NullHandling.initializeForTests();
    }

    @Test
    public void testUnApply() {
        Assert.assertEquals(Collections.singletonList("foo"), (Object)this.fn.unapply("bar"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"null", "empty String"}), (Object)Sets.newHashSet((Iterable)this.fn.unapply("")));
        if (NullHandling.sqlCompatible()) {
            Assert.assertEquals((String)"Null value should be equal to empty list", new HashSet(), (Object)Sets.newHashSet((Iterable)this.fn.unapply((String)null)));
        } else {
            Assert.assertEquals((String)"Null value should be equal to empty string", (Object)Sets.newHashSet((Object[])new String[]{"null", "empty String"}), (Object)Sets.newHashSet((Iterable)this.fn.unapply((String)null)));
        }
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{""}), (Object)Sets.newHashSet((Iterable)this.fn.unapply("empty_string")));
        Assert.assertEquals((String)"not existing value returns empty list", Collections.emptyList(), (Object)this.fn.unapply("not There"));
    }

    @Test
    public void testGetMap() {
        Assert.assertEquals(this.lookupMap, (Object)this.fn.getMap());
    }

    @Test
    public void testApply() {
        Assert.assertEquals((Object)"bar", (Object)this.fn.apply("foo"));
    }

    @Test
    public void testGetCacheKey() {
        MapLookupExtractor fn2 = new MapLookupExtractor((Map)ImmutableMap.copyOf(this.lookupMap), false);
        Assert.assertArrayEquals((byte[])this.fn.getCacheKey(), (byte[])fn2.getCacheKey());
        MapLookupExtractor fn3 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo2", (Object)"bar"), false);
        Assert.assertFalse((boolean)Arrays.equals(this.fn.getCacheKey(), fn3.getCacheKey()));
        MapLookupExtractor fn4 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar2"), false);
        Assert.assertFalse((boolean)Arrays.equals(this.fn.getCacheKey(), fn4.getCacheKey()));
    }

    @Test
    public void testCanIterate() {
        Assert.assertTrue((boolean)this.fn.canIterate());
    }

    @Test
    public void testIterable() {
        Assert.assertEquals((Object)ImmutableList.copyOf(this.lookupMap.entrySet()), (Object)ImmutableList.copyOf((Iterable)this.fn.iterable()));
    }

    @Test
    public void testEquals() {
        MapLookupExtractor fn2 = new MapLookupExtractor((Map)ImmutableMap.copyOf(this.lookupMap), false);
        Assert.assertEquals((Object)this.fn, (Object)fn2);
        MapLookupExtractor fn3 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo2", (Object)"bar"), false);
        Assert.assertNotEquals((Object)this.fn, (Object)fn3);
        MapLookupExtractor fn4 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar2"), false);
        Assert.assertNotEquals((Object)this.fn, (Object)fn4);
    }

    @Test
    public void testHashCode() {
        MapLookupExtractor fn2 = new MapLookupExtractor((Map)ImmutableMap.copyOf(this.lookupMap), false);
        Assert.assertEquals((long)this.fn.hashCode(), (long)fn2.hashCode());
        MapLookupExtractor fn3 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo2", (Object)"bar"), false);
        Assert.assertNotEquals((long)this.fn.hashCode(), (long)fn3.hashCode());
        MapLookupExtractor fn4 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar2"), false);
        Assert.assertNotEquals((long)this.fn.hashCode(), (long)fn4.hashCode());
    }
}

