/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DimFilterUtilsTest {
    private static final Function<ShardSpec, ShardSpec> CONVERTER = new Function<ShardSpec, ShardSpec>(){

        @Nullable
        public ShardSpec apply(@Nullable ShardSpec input) {
            return input;
        }
    };

    @Test
    public void testFilterShards() {
        DimFilter filter1 = (DimFilter)EasyMock.createMock(DimFilter.class);
        EasyMock.expect((Object)filter1.getDimensionRangeSet("dim1")).andReturn(DimFilterUtilsTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"abc"))))).anyTimes();
        EasyMock.expect((Object)filter1.getDimensionRangeSet("dim2")).andReturn(null).anyTimes();
        ShardSpec shard1 = DimFilterUtilsTest.shardSpec("dim1", true);
        ShardSpec shard2 = DimFilterUtilsTest.shardSpec("dim1", false);
        ShardSpec shard3 = DimFilterUtilsTest.shardSpec("dim1", false);
        ShardSpec shard4 = DimFilterUtilsTest.shardSpec("dim2", false);
        ShardSpec shard5 = DimFilterUtilsTest.shardSpec("dim2", false);
        ShardSpec shard6 = DimFilterUtilsTest.shardSpec("dim2", false);
        ShardSpec shard7 = DimFilterUtilsTest.shardSpec("dim2", false);
        ImmutableList shards = ImmutableList.of((Object)shard1, (Object)shard2, (Object)shard3, (Object)shard4, (Object)shard5, (Object)shard6, (Object)shard7);
        EasyMock.replay((Object[])new Object[]{filter1, shard1, shard2, shard3, shard4, shard5, shard6, shard7});
        ImmutableSet expected1 = ImmutableSet.of((Object)shard1, (Object)shard4, (Object)shard5, (Object)shard6, (Object)shard7);
        this.assertFilterResult(filter1, (Iterable<ShardSpec>)shards, (Set<ShardSpec>)expected1);
    }

    private void assertFilterResult(DimFilter filter, Iterable<ShardSpec> input, Set<ShardSpec> expected) {
        HashSet result = DimFilterUtils.filterShards((DimFilter)filter, input, CONVERTER);
        Assert.assertEquals(expected, (Object)result);
        HashMap dimensionRangeMap = new HashMap();
        result = new HashSet();
        for (ShardSpec shard : input) {
            result.addAll(DimFilterUtils.filterShards((DimFilter)filter, (Iterable)ImmutableList.of((Object)shard), CONVERTER, dimensionRangeMap));
        }
        Assert.assertEquals(expected, result);
    }

    private static RangeSet<String> rangeSet(List<Range<String>> ranges) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range<String> range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    private static ShardSpec shardSpec(String dimension, boolean contained) {
        ShardSpec shard = (ShardSpec)EasyMock.createMock(ShardSpec.class);
        EasyMock.expect((Object)shard.getDomainDimensions()).andReturn((Object)ImmutableList.of((Object)dimension)).anyTimes();
        EasyMock.expect((Object)shard.possibleInDomain((Map)EasyMock.anyObject())).andReturn((Object)contained).anyTimes();
        return shard;
    }
}

