/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.nary.TrinaryFn;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NestedDataGroupByQueryTest
extends InitializedNullHandlingTest {
    private static final Logger LOG = new Logger(NestedDataGroupByQueryTest.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final Closer closer;
    private final GroupByQueryConfig config;
    private final QueryContexts.Vectorize vectorize;
    private final AggregationTestHelper helper;
    private final TrinaryFn<AggregationTestHelper, TemporaryFolder, Closer, List<Segment>> segmentsGenerator;
    private final String segmentsName;
    private boolean cannotVectorize = false;

    public NestedDataGroupByQueryTest(GroupByQueryConfig config, TrinaryFn<AggregationTestHelper, TemporaryFolder, Closer, List<Segment>> segmentGenerator, String vectorize) {
        NestedDataModule.registerHandlersAndSerde();
        this.config = config;
        this.vectorize = QueryContexts.Vectorize.fromString((String)vectorize);
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(NestedDataModule.getJacksonModulesList(), config, this.tempFolder);
        this.segmentsGenerator = segmentGenerator;
        this.segmentsName = segmentGenerator.toString();
        this.closer = Closer.create();
    }

    public Map<String, Object> getContext() {
        return ImmutableMap.of((Object)"vectorize", (Object)this.vectorize.toString(), (Object)"vectorizeVirtualColumns", (Object)"true");
    }

    @Parameterized.Parameters(name="config = {0}, segments = {1}, vectorize = {2}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        List<TrinaryFn<AggregationTestHelper, TemporaryFolder, Closer, List<Segment>>> segmentsGenerators = NestedDataTestUtils.getSegmentGenerators();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            for (TrinaryFn<AggregationTestHelper, TemporaryFolder, Closer, List<Segment>> generatorFn : segmentsGenerators) {
                for (String vectorize : new String[]{"false", "true", "force"}) {
                    constructors.add(new Object[]{config, generatorFn, vectorize});
                }
            }
        }
        return constructors;
    }

    @Before
    public void setup() {
        if (!"segments".equals(this.segmentsName)) {
            if ("v1".equals(this.config.getDefaultStrategy())) {
                this.expectedException.expect(RuntimeException.class);
                this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
            } else if (this.vectorize == QueryContexts.Vectorize.FORCE) {
                this.expectedException.expect(RuntimeException.class);
                this.expectedException.expectMessage("Cannot vectorize!");
            }
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testGroupBySomeField() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List)this.segmentsGenerator.apply((Object)this.helper, (Object)this.tempFolder, (Object)this.closer), groupQuery);
        List results = seq.toList();
        NestedDataGroupByQueryTest.verifyResults(groupQuery.getResultRowSignature(), results, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 2L}, (Object)new Object[]{"300", 4L}));
    }

    @Test
    public void testGroupBySomeFieldWithFilter() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(NullHandling.defaultStringValue());
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List)this.segmentsGenerator.apply((Object)this.helper, (Object)this.tempFolder, (Object)this.closer), groupQuery);
        List results = seq.toList();
        NestedDataGroupByQueryTest.verifyResults(groupQuery.getResultRowSignature(), results, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{"100", 2L}, (Object)new Object[]{"200", 2L}, (Object)new Object[]{"300", 4L}));
    }

    @Test
    public void testGroupByNoFieldWithFilter() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(NullHandling.defaultStringValue());
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.fake", "v0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).setDimFilter((DimFilter)new InDimFilter("v0", vals, null)).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List)this.segmentsGenerator.apply((Object)this.helper, (Object)this.tempFolder, (Object)this.closer), groupQuery);
        List results = seq.toList();
        NestedDataGroupByQueryTest.verifyResults(groupQuery.getResultRowSignature(), results, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 16L}));
    }

    @Test
    public void testGroupBySomeFieldWithNonExistentAgg() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(NullHandling.defaultStringValue());
        vals.add("100");
        vals.add("200");
        vals.add("300");
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.nope", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.STRING), new NestedFieldVirtualColumn("nest", "$.fake", "v2", ColumnType.DOUBLE)}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v2")}).setDimFilter((DimFilter)new InDimFilter("v1", vals, null)).setContext(this.getContext()).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List)this.segmentsGenerator.apply((Object)this.helper, (Object)this.tempFolder, (Object)this.closer), groupQuery);
        List results = seq.toList();
        NestedDataGroupByQueryTest.verifyResults(groupQuery.getResultRowSignature(), results, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, NullHandling.defaultLongValue()}));
    }

    @Test
    public void testGroupByNonExistentVirtualColumn() {
        if ("v1".equals(this.config.getDefaultStrategy())) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v1")}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("fake", "$.fake", "v0", ColumnType.STRING), new ExpressionVirtualColumn("v1", "concat(v0, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List)this.segmentsGenerator.apply((Object)this.helper, (Object)this.tempFolder, (Object)this.closer), groupQuery);
        List results = seq.toList();
        NestedDataGroupByQueryTest.verifyResults(groupQuery.getResultRowSignature(), results, (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{null, 16L}) : ImmutableList.of((Object)new Object[]{"foo", 16L})));
    }

    private static void verifyResults(RowSignature rowSignature, List<ResultRow> results, List<Object[]> expected) {
        LOG.info("results:\n%s", new Object[]{results});
        Assert.assertEquals((long)expected.size(), (long)results.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object[] resultRow = results.get(i).getArray();
            Assert.assertEquals((long)expected.get(i).length, (long)resultRow.length);
            for (int j = 0; j < resultRow.length; ++j) {
                if (rowSignature.getColumnType(j).map(t -> t.anyOf((TypeDescriptor[])new ValueType[]{ValueType.DOUBLE, ValueType.FLOAT})).orElse(false).booleanValue()) {
                    Assert.assertEquals((double)((Double)expected.get(i)[j]), (double)((Double)resultRow[j]), (double)0.01);
                    continue;
                }
                Assert.assertEquals((Object)expected.get(i)[j], (Object)resultRow[j]);
            }
        }
    }
}

