/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import java.nio.ByteBuffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.HashVectorGrouper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HashVectorGrouperTest {
    @Test
    public void testCloseAggregatorAdaptorsShouldBeClosed() {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[4096]);
        AggregatorAdapters aggregatorAdapters = (AggregatorAdapters)Mockito.mock(AggregatorAdapters.class);
        HashVectorGrouper grouper = new HashVectorGrouper(Suppliers.ofInstance((Object)buffer), 1024, aggregatorAdapters, Integer.MAX_VALUE, 0.0f, 0);
        grouper.initVectorized(512);
        grouper.close();
        ((AggregatorAdapters)Mockito.verify((Object)aggregatorAdapters, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testTableStartIsNotMemoryStartIfNotMaxSized() {
        int maxVectorSize = 512;
        int keySize = 4;
        int bufferSize = 102400;
        WritableMemory keySpace = WritableMemory.allocate((int)2048);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[102400]);
        AggregatorAdapters aggregatorAdapters = (AggregatorAdapters)Mockito.mock(AggregatorAdapters.class);
        HashVectorGrouper grouper = new HashVectorGrouper(Suppliers.ofInstance((Object)buffer), 4, aggregatorAdapters, 8, 0.0f, 4);
        grouper.initVectorized(512);
        Assert.assertNotEquals((long)0L, (long)grouper.getTableStart());
    }

    @Test
    public void testTableStartIsNotMemoryStartIfIsMaxSized() {
        int maxVectorSize = 512;
        int keySize = 10000;
        int bufferSize = 102400;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[102400]);
        AggregatorAdapters aggregatorAdapters = (AggregatorAdapters)Mockito.mock(AggregatorAdapters.class);
        HashVectorGrouper grouper = new HashVectorGrouper(Suppliers.ofInstance((Object)buffer), 10000, aggregatorAdapters, 4, 0.0f, 4);
        grouper.initVectorized(512);
        Assert.assertEquals((long)0L, (long)grouper.getTableStart());
    }

    @Test
    public void testGrowOnce() {
        int maxVectorSize = 512;
        int keySize = 4;
        int aggSize = 8;
        WritableMemory keySpace = WritableMemory.allocate((int)2048);
        AggregatorAdapters aggregatorAdapters = (AggregatorAdapters)Mockito.mock(AggregatorAdapters.class);
        Mockito.when((Object)aggregatorAdapters.spaceNeeded()).thenReturn((Object)8);
        int startingNumBuckets = 4;
        int maxBuckets = 16;
        int bufferSize = 12 * maxBuckets;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[bufferSize]);
        HashVectorGrouper grouper = new HashVectorGrouper(Suppliers.ofInstance((Object)buffer), 4, aggregatorAdapters, maxBuckets, 0.0f, startingNumBuckets);
        grouper.initVectorized(512);
        int tableStart = grouper.getTableStart();
        this.fillKeyspace(keySpace, 512, 2);
        AggregateResult result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)tableStart, (long)grouper.getTableStart());
        this.fillKeyspace(keySpace, 512, 3);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)0L, (long)grouper.getTableStart());
    }

    @Test
    public void testGrowTwice() {
        int maxVectorSize = 512;
        int keySize = 4;
        int aggSize = 8;
        WritableMemory keySpace = WritableMemory.allocate((int)2048);
        AggregatorAdapters aggregatorAdapters = (AggregatorAdapters)Mockito.mock(AggregatorAdapters.class);
        Mockito.when((Object)aggregatorAdapters.spaceNeeded()).thenReturn((Object)8);
        int startingNumBuckets = 4;
        int maxBuckets = 32;
        int bufferSize = 12 * maxBuckets;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[bufferSize]);
        HashVectorGrouper grouper = new HashVectorGrouper(Suppliers.ofInstance((Object)buffer), 4, aggregatorAdapters, maxBuckets, 0.0f, startingNumBuckets);
        grouper.initVectorized(512);
        int tableStart = grouper.getTableStart();
        this.fillKeyspace(keySpace, 512, 2);
        AggregateResult result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)tableStart, (long)grouper.getTableStart());
        this.fillKeyspace(keySpace, 512, 3);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertTrue((grouper.getTableStart() > tableStart ? 1 : 0) != 0);
        this.fillKeyspace(keySpace, 512, 6);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)0L, (long)grouper.getTableStart());
    }

    @Test
    public void testGrowThreeTimes() {
        int maxVectorSize = 512;
        int keySize = 4;
        int aggSize = 8;
        WritableMemory keySpace = WritableMemory.allocate((int)2048);
        AggregatorAdapters aggregatorAdapters = (AggregatorAdapters)Mockito.mock(AggregatorAdapters.class);
        Mockito.when((Object)aggregatorAdapters.spaceNeeded()).thenReturn((Object)8);
        int startingNumBuckets = 4;
        int maxBuckets = 64;
        int bufferSize = 12 * maxBuckets;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[bufferSize]);
        HashVectorGrouper grouper = new HashVectorGrouper(Suppliers.ofInstance((Object)buffer), 4, aggregatorAdapters, maxBuckets, 0.0f, startingNumBuckets);
        grouper.initVectorized(512);
        int tableStart = grouper.getTableStart();
        this.fillKeyspace(keySpace, 512, 2);
        AggregateResult result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)tableStart, (long)grouper.getTableStart());
        this.fillKeyspace(keySpace, 512, 3);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertTrue((grouper.getTableStart() > tableStart ? 1 : 0) != 0);
        tableStart = grouper.getTableStart();
        this.fillKeyspace(keySpace, 512, 6);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertTrue((grouper.getTableStart() > tableStart ? 1 : 0) != 0);
        this.fillKeyspace(keySpace, 512, 14);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)0L, (long)grouper.getTableStart());
    }

    @Test
    public void testGrowFourTimes() {
        int maxVectorSize = 512;
        int keySize = 4;
        int aggSize = 8;
        WritableMemory keySpace = WritableMemory.allocate((int)2048);
        AggregatorAdapters aggregatorAdapters = (AggregatorAdapters)Mockito.mock(AggregatorAdapters.class);
        Mockito.when((Object)aggregatorAdapters.spaceNeeded()).thenReturn((Object)8);
        int startingNumBuckets = 4;
        int maxBuckets = 128;
        int bufferSize = 12 * maxBuckets;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[bufferSize]);
        HashVectorGrouper grouper = new HashVectorGrouper(Suppliers.ofInstance((Object)buffer), 4, aggregatorAdapters, maxBuckets, 0.0f, startingNumBuckets);
        grouper.initVectorized(512);
        int tableStart = grouper.getTableStart();
        this.fillKeyspace(keySpace, 512, 2);
        AggregateResult result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)tableStart, (long)grouper.getTableStart());
        this.fillKeyspace(keySpace, 512, 3);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertTrue((grouper.getTableStart() > tableStart ? 1 : 0) != 0);
        tableStart = grouper.getTableStart();
        this.fillKeyspace(keySpace, 512, 6);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertTrue((grouper.getTableStart() > tableStart ? 1 : 0) != 0);
        tableStart = grouper.getTableStart();
        this.fillKeyspace(keySpace, 512, 14);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertTrue((grouper.getTableStart() > tableStart ? 1 : 0) != 0);
        this.fillKeyspace(keySpace, 512, 25);
        result = grouper.aggregateVector((Memory)keySpace, 0, 512);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertEquals((long)0L, (long)grouper.getTableStart());
    }

    private void fillKeyspace(WritableMemory keySpace, int maxVectorSize, int distinctKeys) {
        for (int i = 0; i < maxVectorSize; ++i) {
            int bucket = i % distinctKeys;
            keySpace.putInt(4L * (long)i, bucket);
        }
    }
}

