/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.ArrayStringGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.data.ComparableIntArray;
import org.apache.druid.segment.data.ComparableStringArray;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrayStringGroupByColumnSelectorStrategyTest {
    private final BiMap<String, Integer> DICTIONARY_INT = HashBiMap.create((Map)new HashMap<String, Integer>(){
        {
            this.put("a", 0);
            this.put("b", 1);
            this.put("bd", 2);
            this.put("d", 3);
            this.put("e", 4);
        }
    });
    private final BiMap<ComparableIntArray, Integer> INDEXED_INTARRAYS = HashBiMap.create((Map)new HashMap<ComparableIntArray, Integer>(){
        {
            this.put(ComparableIntArray.of((int[])new int[]{0, 1}), 0);
            this.put(ComparableIntArray.of((int[])new int[]{2, 4}), 1);
            this.put(ComparableIntArray.of((int[])new int[]{0, 2}), 2);
        }
    });
    private final ByteBuffer buffer1 = ByteBuffer.allocate(4);
    private final ByteBuffer buffer2 = ByteBuffer.allocate(4);
    private ArrayStringGroupByColumnSelectorStrategy strategy;

    @Before
    public void setup() {
        this.strategy = new ArrayStringGroupByColumnSelectorStrategy(this.DICTIONARY_INT, this.INDEXED_INTARRAYS);
    }

    @Test
    public void testKeySize() {
        Assert.assertEquals((long)4L, (long)this.strategy.getGroupingKeySize());
    }

    @Test
    public void testWriteKey() {
        this.strategy.writeToKeyBuffer(0, 1, this.buffer1);
        Assert.assertEquals((long)1L, (long)this.buffer1.getInt(0));
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndNullStringComparatorShouldUseLexicographicComparator() {
        this.buffer1.putInt(1);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, null);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndLexicographicStringComparatorShouldUseLexicographicComparator() {
        this.buffer1.putInt(1);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, StringComparators.LEXICOGRAPHIC);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndStrLenStringComparatorShouldUseLexicographicComparator() {
        this.buffer1.putInt(1);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, StringComparators.STRLEN);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSanity() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)ImmutableList.of((Object)"a", (Object)"b"));
        Assert.assertEquals((long)0L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(0);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)ComparableStringArray.of((String[])new String[]{"a", "b"}), (Object)row.get(0));
    }

    @Test
    public void testAddingInDictionary() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)ImmutableList.of((Object)"f", (Object)"a"));
        Assert.assertEquals((long)3L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(3);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)ComparableStringArray.of((String[])new String[]{"f", "a"}), (Object)row.get(0));
    }

    @Test
    public void testAddingInDictionaryWithObjects() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)new Object[]{"f", "a"});
        Assert.assertEquals((long)3L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(3);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)ComparableStringArray.of((String[])new String[]{"f", "a"}), (Object)row.get(0));
    }

    @After
    public void tearDown() {
        this.buffer1.clear();
        this.buffer2.clear();
    }
}

