/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.StringGroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StringGroupByColumnSelectorStrategyTest {
    private static final Int2ObjectMap<String> DICTIONARY = new Int2ObjectArrayMap(new int[]{0, 1, 2}, (Object[])new String[]{"A", "F1", "D"});
    private final ByteBuffer lhsBuffer = ByteBuffer.allocate(4);
    private final ByteBuffer rhsBuffer = ByteBuffer.allocate(4);
    @Mock
    private ColumnCapabilities capabilities;
    private final IntFunction<String> dictionaryLookup = arg_0 -> DICTIONARY.get(arg_0);
    private StringGroupByColumnSelectorStrategy target;

    @Before
    public void setUp() {
        this.lhsBuffer.putInt(1);
        this.rhsBuffer.putInt(2);
        ((ColumnCapabilities)Mockito.doReturn((Object)true).when((Object)this.capabilities)).hasBitmapIndexes();
        ((ColumnCapabilities)Mockito.doReturn((Object)ColumnCapabilities.Capable.TRUE).when((Object)this.capabilities)).areDictionaryValuesSorted();
        ((ColumnCapabilities)Mockito.doReturn((Object)ColumnCapabilities.Capable.TRUE).when((Object)this.capabilities)).areDictionaryValuesUnique();
        this.target = new StringGroupByColumnSelectorStrategy(this.dictionaryLookup, this.capabilities);
    }

    @Test
    public void testBufferComparatorCannotCompareIntsAndNullStringComparatorShouldUseLexicographicComparator() {
        Mockito.when((Object)this.capabilities.areDictionaryValuesSorted()).thenReturn((Object)ColumnCapabilities.Capable.FALSE);
        Grouper.BufferComparator comparator = this.target.bufferComparator(0, null);
        Assert.assertTrue((comparator.compare(this.lhsBuffer, this.rhsBuffer, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.rhsBuffer, this.lhsBuffer, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndNullStringComparatorShouldUseLexicographicComparator() {
        Grouper.BufferComparator comparator = this.target.bufferComparator(0, null);
        Assert.assertTrue((comparator.compare(this.lhsBuffer, this.rhsBuffer, 0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.rhsBuffer, this.lhsBuffer, 0, 0) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndLexicographicStringComparatorShouldUseLexicographicComparator() {
        Grouper.BufferComparator comparator = this.target.bufferComparator(0, StringComparators.LEXICOGRAPHIC);
        Assert.assertTrue((comparator.compare(this.lhsBuffer, this.rhsBuffer, 0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.rhsBuffer, this.lhsBuffer, 0, 0) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndStrLenStringComparatorShouldUseLexicographicComparator() {
        Grouper.BufferComparator comparator = this.target.bufferComparator(0, StringComparators.STRLEN);
        Assert.assertTrue((comparator.compare(this.lhsBuffer, this.rhsBuffer, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.rhsBuffer, this.lhsBuffer, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @After
    public void tearDown() {
        this.lhsBuffer.clear();
        this.rhsBuffer.clear();
    }
}

