/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.junit.Assert;
import org.junit.Test;

public class PreJoinableClauseTest {
    private final PreJoinableClause clause = new PreJoinableClause("j.", (DataSource)new TableDataSource("foo"), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"j.x\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));

    @Test
    public void test_getPrefix() {
        Assert.assertEquals((Object)"j.", (Object)this.clause.getPrefix());
    }

    @Test
    public void test_getJoinType() {
        Assert.assertEquals((Object)JoinType.LEFT, (Object)this.clause.getJoinType());
    }

    @Test
    public void test_getCondition() {
        Assert.assertEquals((Object)"x == \"j.x\"", (Object)this.clause.getCondition().getOriginalExpression());
    }

    @Test
    public void test_getDataSource() {
        Assert.assertEquals((Object)new TableDataSource("foo"), (Object)this.clause.getDataSource());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(PreJoinableClause.class).usingGetClass().withNonnullFields(new String[]{"prefix", "dataSource", "joinType", "condition"}).verify();
    }
}

