/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.scan.ScanQueryOffsetSequence;
import org.apache.druid.query.scan.ScanResultValue;
import org.junit.Assert;
import org.junit.Test;

public class ScanQueryOffsetSequenceTest {
    private final List<List<Integer>> rowList1 = ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)5, (Object)6));
    private final List<List<Integer>> rowList2 = ImmutableList.of((Object)ImmutableList.of((Object)7, (Object)8), (Object)ImmutableList.of((Object)9, (Object)10), (Object)ImmutableList.of((Object)11, (Object)12));

    @Test
    public void testSkip() {
        List<ScanResultValue> unskipped = this.makeExpectedResults(0);
        for (int skip = 1; skip <= this.rowList1.size() + this.rowList2.size() + 1; ++skip) {
            List<ScanResultValue> expected = this.makeExpectedResults(skip);
            List resultsAfterSkip = new ScanQueryOffsetSequence(Sequences.simple(unskipped), (long)skip).toList();
            Assert.assertEquals((String)("skip = " + skip), expected, (Object)resultsAfterSkip);
        }
    }

    private List<ScanResultValue> makeExpectedResults(int skip) {
        ImmutableList expected = skip < this.rowList1.size() ? ImmutableList.of((Object)new ScanResultValue("1", (List)ImmutableList.of((Object)"a", (Object)"b"), this.rowList1.subList(skip, this.rowList1.size())), (Object)new ScanResultValue("2", (List)ImmutableList.of((Object)"b", (Object)"c"), this.rowList2)) : (skip < this.rowList1.size() + this.rowList2.size() ? ImmutableList.of((Object)new ScanResultValue("2", (List)ImmutableList.of((Object)"b", (Object)"c"), this.rowList2.subList(skip - this.rowList1.size(), this.rowList2.size()))) : ImmutableList.of());
        return expected;
    }
}

