/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.StringDictionaryEncodedColumn;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnSelectorColumnIndexSelectorTest {
    private static final String STRING_DICTIONARY_COLUMN_NAME = "string";
    private static final String NON_STRING_DICTIONARY_COLUMN_NAME = "not-string";
    BitmapFactory bitmapFactory;
    VirtualColumns virtualColumns;
    ColumnSelector index;
    ColumnSelectorColumnIndexSelector indexSelector;
    ColumnIndexSupplier indexSupplier;

    @Before
    public void setup() {
        this.bitmapFactory = (BitmapFactory)EasyMock.createMock(BitmapFactory.class);
        this.virtualColumns = (VirtualColumns)EasyMock.createMock(VirtualColumns.class);
        this.index = (ColumnSelector)EasyMock.createMock(ColumnSelector.class);
        this.indexSelector = new ColumnSelectorColumnIndexSelector(this.bitmapFactory, this.virtualColumns, this.index);
        this.indexSupplier = (ColumnIndexSupplier)EasyMock.createMock(ColumnIndexSupplier.class);
        EasyMock.expect((Object)this.virtualColumns.getVirtualColumn(STRING_DICTIONARY_COLUMN_NAME)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.virtualColumns.getVirtualColumn(NON_STRING_DICTIONARY_COLUMN_NAME)).andReturn(null).anyTimes();
        ColumnHolder holder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        EasyMock.expect((Object)this.index.getColumnHolder(STRING_DICTIONARY_COLUMN_NAME)).andReturn((Object)holder).anyTimes();
        StringDictionaryEncodedColumn stringColumn = (StringDictionaryEncodedColumn)EasyMock.createMock(StringDictionaryEncodedColumn.class);
        EasyMock.expect((Object)holder.getCapabilities()).andReturn((Object)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true)).anyTimes();
        EasyMock.expect((Object)holder.getColumn()).andReturn((Object)stringColumn).anyTimes();
        EasyMock.expect((Object)holder.getIndexSupplier()).andReturn((Object)this.indexSupplier).anyTimes();
        StringValueSetIndex someIndex = (StringValueSetIndex)EasyMock.createMock(StringValueSetIndex.class);
        EasyMock.expect((Object)this.indexSupplier.as(StringValueSetIndex.class)).andReturn((Object)someIndex).anyTimes();
        DictionaryEncodedStringValueIndex valueIndex = (DictionaryEncodedStringValueIndex)EasyMock.createMock(DictionaryEncodedStringValueIndex.class);
        EasyMock.expect((Object)this.indexSupplier.as(DictionaryEncodedStringValueIndex.class)).andReturn((Object)valueIndex).anyTimes();
        BitmapColumnIndex columnIndex = (BitmapColumnIndex)EasyMock.createMock(BitmapColumnIndex.class);
        ImmutableBitmap someBitmap = (ImmutableBitmap)EasyMock.createMock(ImmutableBitmap.class);
        EasyMock.expect((Object)valueIndex.getBitmap(0)).andReturn((Object)someBitmap).anyTimes();
        EasyMock.expect((Object)someIndex.forValue("foo")).andReturn((Object)columnIndex).anyTimes();
        EasyMock.expect((Object)columnIndex.computeBitmapResult((BitmapResultFactory)EasyMock.anyObject())).andReturn((Object)someBitmap).anyTimes();
        ColumnHolder nonStringHolder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        EasyMock.expect((Object)this.index.getColumnHolder(NON_STRING_DICTIONARY_COLUMN_NAME)).andReturn((Object)nonStringHolder).anyTimes();
        EasyMock.expect((Object)nonStringHolder.getIndexSupplier()).andReturn((Object)new NoIndexesColumnIndexSupplier()).anyTimes();
        EasyMock.expect((Object)nonStringHolder.getCapabilities()).andReturn((Object)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.ofComplex((String)"testBlob")).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true).setFilterable(true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.bitmapFactory, this.virtualColumns, this.index, this.indexSupplier, holder, stringColumn, nonStringHolder, someIndex, columnIndex, valueIndex, someBitmap});
    }

    @Test
    public void testStringDictionaryUseIndex() {
        ColumnIndexSupplier supplier = this.indexSelector.getIndexSupplier(STRING_DICTIONARY_COLUMN_NAME);
        DictionaryEncodedStringValueIndex bitmapIndex = (DictionaryEncodedStringValueIndex)supplier.as(DictionaryEncodedStringValueIndex.class);
        Assert.assertNotNull((Object)bitmapIndex);
        StringValueSetIndex valueIndex = (StringValueSetIndex)supplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueIndex);
        ImmutableBitmap valueBitmap = (ImmutableBitmap)valueIndex.forValue("foo").computeBitmapResult((BitmapResultFactory)new DefaultBitmapResultFactory(this.indexSelector.getBitmapFactory()));
        Assert.assertNotNull((Object)valueBitmap);
        EasyMock.verify((Object[])new Object[]{this.bitmapFactory, this.virtualColumns, this.index, this.indexSupplier});
    }

    @Test
    public void testNonStringDictionaryDoNotUseIndex() {
        ColumnIndexSupplier supplier = this.indexSelector.getIndexSupplier(NON_STRING_DICTIONARY_COLUMN_NAME);
        DictionaryEncodedStringValueIndex bitmapIndex = (DictionaryEncodedStringValueIndex)supplier.as(DictionaryEncodedStringValueIndex.class);
        Assert.assertNull((Object)bitmapIndex);
        StringValueSetIndex valueIndex = (StringValueSetIndex)supplier.as(StringValueSetIndex.class);
        Assert.assertNull((Object)valueIndex);
        EasyMock.verify((Object[])new Object[]{this.bitmapFactory, this.virtualColumns, this.index, this.indexSupplier});
    }
}

