/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.IdMapping;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IdMappingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testMappingKnownCardinality() {
        int cardinality = 10;
        IdMapping.Builder builder = IdMapping.Builder.ofCardinality((int)10);
        for (int i = 0; i < 10; ++i) {
            builder.addMapping(i * 10);
        }
        IdMapping mapping = builder.build();
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(i * 10), (long)mapping.getReverseId(i));
            Assert.assertEquals((long)i, (long)mapping.getForwardedId(i * 10));
        }
        Assert.assertEquals((long)-1L, (long)mapping.getForwardedId(1));
        Assert.assertEquals((long)-1L, (long)mapping.getForwardedId(-1));
        Assert.assertEquals((long)-1L, (long)mapping.getReverseId(-1));
        Assert.assertEquals((long)-1L, (long)mapping.getReverseId(10));
    }

    @Test
    public void testMappingUnknownCardinality() {
        int cardinality = 10;
        IdMapping.Builder builder = IdMapping.Builder.ofUnknownCardinality();
        for (int i = 0; i < 10; ++i) {
            builder.addForwardMapping(i * 10);
        }
        IdMapping mapping = builder.build();
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(i * 10), (long)mapping.getReverseId(i));
            Assert.assertEquals((long)i, (long)mapping.getForwardedId(i * 10));
        }
        Assert.assertEquals((long)-1L, (long)mapping.getForwardedId(1));
        Assert.assertEquals((long)-1L, (long)mapping.getForwardedId(-1));
        Assert.assertEquals((long)-1L, (long)mapping.getReverseId(-1));
        Assert.assertEquals((long)-1L, (long)mapping.getReverseId(10));
    }

    @Test
    public void testMappingCardinalityUnknownKnown() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("addForwardMapping instead");
        int cardinality = 10;
        IdMapping.Builder builder = IdMapping.Builder.ofUnknownCardinality();
        for (int i = 0; i < 10; ++i) {
            builder.addMapping(i * 10);
        }
    }

    @Test
    public void testMappingCardinalityKnownUnknown() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("addMapping instead");
        int cardinality = 10;
        IdMapping.Builder builder = IdMapping.Builder.ofCardinality((int)10);
        for (int i = 0; i < 10; ++i) {
            builder.addForwardMapping(i * 10);
        }
    }
}

