/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressionStrategyTest {
    protected final CompressionStrategy compressionStrategy;
    private static final int DATA_SIZER = 65535;
    private static byte[] ORIGINAL_DATA;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> compressionStrategies() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompressionStrategyTest(CompressionStrategy compressionStrategy) {
        this.compressionStrategy = compressionStrategy;
    }

    @BeforeClass
    public static void setupClass() {
        ORIGINAL_DATA = new byte[65535];
        Random random = new Random(54671457L);
        random.nextBytes(ORIGINAL_DATA);
    }

    @Test
    public void testBasicOperations() throws IOException {
        try (Closer closer = Closer.create();
             ResourceHolder holder = ByteBufferUtils.allocateDirect((int)ORIGINAL_DATA.length);){
            ByteBuffer compressionOut = this.compressionStrategy.getCompressor().allocateOutBuffer(ORIGINAL_DATA.length, closer);
            ByteBuffer compressionIn = this.compressionStrategy.getCompressor().allocateInBuffer(ORIGINAL_DATA.length, closer);
            ByteBuffer output = (ByteBuffer)holder.get();
            compressionIn.put(ORIGINAL_DATA);
            compressionIn.rewind();
            ByteBuffer compressed = this.compressionStrategy.getCompressor().compress(compressionIn, compressionOut);
            this.compressionStrategy.getDecompressor().decompress(compressed, compressed.remaining(), output);
            byte[] checkArray = new byte[65535];
            output.get(checkArray);
            Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])ORIGINAL_DATA, (byte[])checkArray);
        }
    }

    @Test(timeout=60000L)
    public void testConcurrency() throws Exception {
        int numThreads = 20;
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(20);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(20, 20, 100L, TimeUnit.MILLISECONDS, queue);
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 20; ++i) {
            results.add(threadPoolExecutor.submit(() -> {
                try (Closer closer = Closer.create();){
                    ByteBuffer compressionOut = this.compressionStrategy.getCompressor().allocateOutBuffer(ORIGINAL_DATA.length, closer);
                    ByteBuffer compressionIn = this.compressionStrategy.getCompressor().allocateInBuffer(ORIGINAL_DATA.length, closer);
                    compressionIn.put(ORIGINAL_DATA);
                    compressionIn.position(0);
                    ByteBuffer compressed = this.compressionStrategy.getCompressor().compress(compressionIn, compressionOut);
                    ByteBuffer output = this.compressionStrategy.getCompressor().allocateOutBuffer(ORIGINAL_DATA.length, closer);
                    this.compressionStrategy.getDecompressor().decompress(compressed, compressed.remaining(), output);
                    byte[] checkArray = new byte[65535];
                    output.get(checkArray);
                    Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])ORIGINAL_DATA, (byte[])checkArray);
                    Boolean bl = true;
                    return bl;
                }
            }));
        }
        threadPoolExecutor.shutdown();
        for (Future future : results) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }
}

