/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.SearchQueryFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchQueryFilterTest
extends BaseFilterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public SearchQueryFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, DEFAULT_ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(SearchQueryFilterTest.class.getName());
    }

    private SearchQuerySpec specForValue(String value) {
        return new ContainsSearchQuerySpec(value, true);
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim0", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim0", this.specForValue("0"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim0", this.specForValue("5"), null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("10"), null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("2"), null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("1"), null), (List<String>)ImmutableList.of((Object)"1", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("def"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("abc"), null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ab"), null), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testMultiValueStringColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4"));
        } else {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4"));
        }
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("a"), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("b"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("c"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("d"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue(""), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue(""), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testSearchQueryWithExtractionFn() {
        String nullJsFn = "function(str) { if (str === null) { return 'NOT_NULL_ANYMORE'; } else { return str;} }";
        JavaScriptExtractionFn changeNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
        }
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ab"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ab"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("a"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("a"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("a"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(SearchQueryFilter.class).withIgnoredFields(new String[]{"predicateFactory"}).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForSearchQueryDruidPredicateFactory() {
        EqualsVerifier.forClass(SearchQueryFilter.SearchQueryDruidPredicateFactory.class).usingGetClass().verify();
    }

    @Test
    public void testRequiredColumnRewrite() {
        Filter filter = new SearchQueryDimFilter("dim0", this.specForValue("a"), null).toFilter();
        Filter filter2 = new SearchQueryDimFilter("dim1", this.specForValue("a"), null).toFilter();
        Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
        Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
        Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
        Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0");
        filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1"));
    }
}

