/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.serde.DictionaryEncodedColumnSupplier;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValueMatchersTest
extends InitializedNullHandlingTest {
    private DictionaryEncodedColumnSupplier supplierSingleConstant;
    private DictionaryEncodedColumnSupplier supplierSingle;
    private DictionaryEncodedColumnSupplier supplierMulti;

    @Before
    public void setup() {
        this.supplierSingleConstant = new DictionaryEncodedColumnSupplier(GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)"value"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value"))), (ObjectStrategy)GenericIndexed.BYTE_BUFFER_STRATEGY), () -> VSizeColumnarInts.fromArray((int[])new int[]{0}), null, 0);
        this.supplierSingle = new DictionaryEncodedColumnSupplier(GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)"value", (Object)"value2"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value2"))), (ObjectStrategy)GenericIndexed.BYTE_BUFFER_STRATEGY), () -> VSizeColumnarInts.fromArray((int[])new int[]{0, 0, 1, 0, 1}), null, 0);
        this.supplierMulti = new DictionaryEncodedColumnSupplier(GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)"value"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value"))), (ObjectStrategy)GenericIndexed.BYTE_BUFFER_STRATEGY), null, () -> VSizeColumnarMultiInts.fromIterable((Iterable)ImmutableList.of((Object)VSizeColumnarInts.fromArray((int[])new int[]{0, 0}), (Object)VSizeColumnarInts.fromArray((int[])new int[]{0}))), 0);
    }

    @Test
    public void testNullDimensionSelectorCanBeBoolean() {
        Boolean resultMatchNull = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)DimensionSelector.constant(null), (boolean)false, string -> string == null);
        Assert.assertNotNull((Object)resultMatchNull);
        Assert.assertTrue((boolean)resultMatchNull);
        Boolean resultMatchNotNull = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)DimensionSelector.constant(null), (boolean)false, string -> string != null);
        Assert.assertNotNull((Object)resultMatchNotNull);
        Assert.assertFalse((boolean)resultMatchNotNull);
        Boolean resultMatchNonNilConstant = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)this.supplierSingleConstant.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), (boolean)false, string -> string != null);
        Assert.assertNotNull((Object)resultMatchNonNilConstant);
        Assert.assertTrue((boolean)resultMatchNonNilConstant);
        Boolean resultMatchNonNil = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)this.supplierSingle.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), (boolean)false, string -> string != null);
        Assert.assertNull((Object)resultMatchNonNil);
        Boolean resultMatchNonNilMulti = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)this.supplierMulti.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), (boolean)true, string -> string != null);
        Assert.assertNull((Object)resultMatchNonNilMulti);
    }

    @Test
    public void testNilVectorSelectorCanBeBoolean() {
        Boolean resultMatchNull = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)NilVectorSelector.create((VectorSizeInspector)new NoFilterVectorOffset(10, 0, 100)), (boolean)false, string -> string == null);
        Assert.assertNotNull((Object)resultMatchNull);
        Assert.assertTrue((boolean)resultMatchNull);
        Boolean resultMatchNotNull = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)NilVectorSelector.create((VectorSizeInspector)new NoFilterVectorOffset(10, 0, 100)), (boolean)false, string -> string != null);
        Assert.assertNotNull((Object)resultMatchNotNull);
        Assert.assertFalse((boolean)resultMatchNotNull);
        Boolean resultMatchNotNilConstant = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)this.supplierSingleConstant.get().makeSingleValueDimensionVectorSelector((ReadableVectorOffset)new NoFilterVectorOffset(10, 0, 1)), (boolean)false, string -> string != null);
        Assert.assertNotNull((Object)resultMatchNotNilConstant);
        Assert.assertTrue((boolean)resultMatchNotNilConstant);
        Boolean resultMatchNotNil = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)this.supplierSingle.get().makeSingleValueDimensionVectorSelector((ReadableVectorOffset)new NoFilterVectorOffset(10, 0, 1)), (boolean)false, string -> string != null);
        Assert.assertNull((Object)resultMatchNotNil);
        Boolean resultMatchNotNilMulti = ValueMatchers.toBooleanIfPossible((DimensionDictionarySelector)this.supplierMulti.get().makeSingleValueDimensionVectorSelector((ReadableVectorOffset)new NoFilterVectorOffset(10, 0, 1)), (boolean)true, string -> string != null);
        Assert.assertNull((Object)resultMatchNotNilMulti);
    }
}

