/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.generator.DataGenerator;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorColumnSchema;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.RealRoundingDistribution;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class DataGeneratorTest
extends InitializedNullHandlingTest {
    @Test
    public void testSequential() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeSequential((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (int)10, (int)20));
        schemas.add(GeneratorColumnSchema.makeEnumeratedSequential((String)"dimB", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, Arrays.asList("Hello", "World", "Foo", "Bar")));
        schemas.add(GeneratorColumnSchema.makeSequential((String)"dimC", (ValueType)ValueType.STRING, (boolean)false, (int)1, (Double)0.5, (int)30, (int)40));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 100; ++i) {
            InputRow row = dataGenerator.nextRow();
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testDiscreteUniform() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeDiscreteUniform((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (int)10, (int)20));
        schemas.add(GeneratorColumnSchema.makeEnumeratedDiscreteUniform((String)"dimB", (ValueType)ValueType.STRING, (boolean)false, (int)4, null, Arrays.asList("Hello", "World", "Foo", "Bar")));
        schemas.add(GeneratorColumnSchema.makeDiscreteUniform((String)"dimC", (ValueType)ValueType.STRING, (boolean)false, (int)1, (Double)0.5, (int)10, (int)20));
        schemas.add(GeneratorColumnSchema.makeDiscreteUniform((String)"dimD", (ValueType)ValueType.FLOAT, (boolean)false, (int)1, null, (int)100, (int)120));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 100; ++i) {
            InputRow row = dataGenerator.nextRow();
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testRoundedNormal() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeNormal((String)"dimA", (ValueType)ValueType.FLOAT, (boolean)false, (int)1, null, (Double)50.0, (Double)1.0, (boolean)true));
        schemas.add(GeneratorColumnSchema.makeNormal((String)"dimB", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (Double)1000.0, (Double)10.0, (boolean)true));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 1000000; ++i) {
            InputRow row = dataGenerator.nextRow();
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testZipf() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeZipf((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (int)1000, (int)2000, (Double)1.0));
        schemas.add(GeneratorColumnSchema.makeZipf((String)"dimB", (ValueType)ValueType.FLOAT, (boolean)false, (int)1, null, (int)99990, (int)99999, (Double)1.0));
        schemas.add(GeneratorColumnSchema.makeEnumeratedZipf((String)"dimC", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, Arrays.asList("1-Hello", "2-World", "3-Foo", "4-Bar", "5-BA5EBA11", "6-Rocky", "7-Mango", "8-Contango"), (Double)1.0));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 100; ++i) {
            InputRow row = dataGenerator.nextRow();
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testEnumerated() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeEnumerated((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, Arrays.asList("Hello", "World", "Foo", "Bar"), Arrays.asList(0.5, 0.25, 0.15, 0.1)));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 10000; ++i) {
            InputRow row = dataGenerator.nextRow();
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testNormal() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeNormal((String)"dimA", (ValueType)ValueType.FLOAT, (boolean)false, (int)1, null, (Double)8.0, (Double)1.0, (boolean)false));
        schemas.add(GeneratorColumnSchema.makeNormal((String)"dimB", (ValueType)ValueType.STRING, (boolean)false, (int)1, (Double)0.5, (Double)88.0, (Double)2.0, (boolean)false));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 100; ++i) {
            InputRow row = dataGenerator.nextRow();
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testRealUniform() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeContinuousUniform((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (double)10.0, (double)50.0));
        schemas.add(GeneratorColumnSchema.makeContinuousUniform((String)"dimB", (ValueType)ValueType.FLOAT, (boolean)false, (int)1, null, (double)210.0, (double)250.0));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 100; ++i) {
            InputRow row = dataGenerator.nextRow();
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testIntervalBasedTimeGeneration() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        schemas.add(GeneratorColumnSchema.makeEnumeratedSequential((String)"dimB", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, Arrays.asList("Hello", "World", "Foo", "Bar")));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, Intervals.utc((long)50000L, (long)600000L), 100);
        for (int i = 0; i < 100; ++i) {
            dataGenerator.nextRow();
        }
        DataGenerator dataGenerator2 = new DataGenerator(schemas, 9999L, Intervals.utc((long)50000L, (long)50001L), 100);
        for (int i = 0; i < 100; ++i) {
            dataGenerator2.nextRow();
        }
    }

    @Test
    public void testBasicSchemasAndGeneratorSchemaInfo() {
        GeneratorSchemaInfo basicSchema = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("basic");
        Assert.assertEquals((long)13L, (long)basicSchema.getColumnSchemas().size());
        Assert.assertEquals((long)6L, (long)basicSchema.getAggs().size());
        Assert.assertEquals((long)6L, (long)basicSchema.getAggsArray().length);
        Assert.assertNotNull((Object)basicSchema.getDimensionsSpec());
        Assert.assertNotNull((Object)basicSchema.getDataInterval());
        Assert.assertTrue((boolean)basicSchema.isWithRollup());
    }

    @Test
    public void testRealRoundingDistributionZeroGetters() {
        RealRoundingDistribution dist = new RealRoundingDistribution((AbstractRealDistribution)new NormalDistribution());
        Assert.assertEquals((long)0L, (long)dist.getSupportLowerBound());
        Assert.assertEquals((long)0L, (long)dist.getSupportUpperBound());
        Assert.assertEquals((double)0.0, (double)dist.getNumericalMean(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)dist.getNumericalVariance(), (double)0.0);
    }

    @Test
    public void testLazyZipf() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeLazyZipf((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (int)0, (int)1220000, (Double)1.0));
        schemas.add(GeneratorColumnSchema.makeLazyZipf((String)"dimB", (ValueType)ValueType.FLOAT, (boolean)false, (int)1, null, (int)99990, (int)99999, (Double)1.0));
        schemas.add(GeneratorColumnSchema.makeLazyZipf((String)"dimC", (ValueType)ValueType.DOUBLE, (boolean)false, (int)1, null, (int)0, (int)100000, (Double)1.5));
        schemas.add(GeneratorColumnSchema.makeLazyZipf((String)"dimD", (ValueType)ValueType.LONG, (boolean)false, (int)1, null, (int)0, (int)100000, (Double)1.5));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        for (int i = 0; i < 100000; ++i) {
            InputRow row = dataGenerator.nextRow();
            System.out.println("Z-ROW: " + row);
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testToList() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        RowValueTracker tracker = new RowValueTracker();
        schemas.add(GeneratorColumnSchema.makeSequential((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (int)10, (int)20));
        schemas.add(GeneratorColumnSchema.makeEnumeratedSequential((String)"dimB", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, Arrays.asList("Hello", "World", "Foo", "Bar")));
        schemas.add(GeneratorColumnSchema.makeSequential((String)"dimC", (ValueType)ValueType.STRING, (boolean)false, (int)1, (Double)0.5, (int)30, (int)40));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        List rows = dataGenerator.toList(100);
        Assert.assertEquals((long)100L, (long)rows.size());
        for (InputRow row : rows) {
            tracker.addRow(row);
        }
        tracker.printStuff();
    }

    @Test
    public void testToIndex() {
        ArrayList<GeneratorColumnSchema> schemas = new ArrayList<GeneratorColumnSchema>();
        schemas.add(GeneratorColumnSchema.makeSequential((String)"dimA", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, (int)10, (int)20));
        schemas.add(GeneratorColumnSchema.makeEnumeratedSequential((String)"dimB", (ValueType)ValueType.STRING, (boolean)false, (int)1, null, Arrays.asList("Hello", "World", "Foo", "Bar")));
        schemas.add(GeneratorColumnSchema.makeSequential((String)"dimC", (ValueType)ValueType.STRING, (boolean)false, (int)1, (Double)0.5, (int)30, (int)40));
        DataGenerator dataGenerator = new DataGenerator(schemas, 9999L, 0L, 0, Double.valueOf(1000.0));
        DimensionsSpec dimensions = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dimA"), new StringDimensionSchema("dimB"), new StringDimensionSchema("dimC")));
        AggregatorFactory[] metrics = new AggregatorFactory[]{new CountAggregatorFactory("cnt")};
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withDimensionsSpec(dimensions).withMetrics(metrics).withRollup(false).build();
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setSortFacts(false).setMaxRowCount(1000000).build();
        dataGenerator.addToIndex(index, 100);
        Assert.assertEquals((long)100L, (long)index.size());
    }

    private static class RowValueTracker {
        private Map<String, Map<Object, Integer>> dimensionMap = new HashMap<String, Map<Object, Integer>>();

        /*
         * WARNING - void declaration
         */
        public void addRow(InputRow row) {
            for (String dim : row.getDimensions()) {
                if (this.dimensionMap.get(dim) == null) {
                    this.dimensionMap.put(dim, new HashMap());
                }
                Map<Object, Integer> valueMap = this.dimensionMap.get(dim);
                List<Object> dimVals = row.getRaw(dim);
                if (dimVals == null) {
                    dimVals = Collections.singletonList(null);
                } else if (!(dimVals instanceof List)) {
                    dimVals = Collections.singletonList(dimVals);
                }
                List<Object> dimValsList = dimVals;
                for (Object var8_9 : dimValsList) {
                    void var8_8;
                    if (var8_9 == null) {
                        String string = "";
                    }
                    if (valueMap.get(var8_8) == null) {
                        valueMap.put(var8_8, 0);
                    }
                    valueMap.put(var8_8, valueMap.get(var8_8) + 1);
                }
            }
        }

        public void printStuff() {
            System.out.println();
            for (String dim : this.dimensionMap.keySet()) {
                System.out.println("DIMENSION " + dim + "\n============");
                Map<Object, Integer> valueMap = this.dimensionMap.get(dim);
                ArrayList<Comparable> valList = new ArrayList<Comparable>();
                for (Object object : valueMap.keySet()) {
                    valList.add((Comparable)object);
                }
                Collections.sort(valList);
                for (Comparable comparable : valList) {
                    System.out.println(" VAL: " + comparable + " CNT: " + valueMap.get(comparable));
                }
                System.out.println();
            }
        }
    }
}

