/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.parsers.UnparseableColumnsParseException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexTest
extends InitializedNullHandlingTest {
    public final IncrementalIndexCreator indexCreator;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexTest(String indexType, String mode, boolean deserializeComplexMetrics, IncrementalIndexSchema schema) throws JsonProcessingException {
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setIndexSchema(schema).setDeserializeComplexMetrics(deserializeComplexMetrics).setSortFacts("rollup".equals(mode)).setMaxRowCount(1000000).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}, {1}, deserialize={2}")
    public static Collection<?> constructorFeeder() {
        DimensionsSpec dimensions = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("string"), new FloatDimensionSchema("float"), new LongDimensionSchema("long"), new DoubleDimensionSchema("double")));
        AggregatorFactory[] metrics = new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("cnt"), (DimFilter)new SelectorDimFilter("billy", "A", null))};
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withDimensionsSpec(dimensions).withMetrics(metrics).build();
        return IncrementalIndexCreator.indexTypeCartesianProduct(new Collection[]{ImmutableList.of((Object)"rollup", (Object)"plain"), ImmutableList.of((Object)true, (Object)false), ImmutableList.of((Object)schema)});
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensions() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensionsFirstOccurrence() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void controlTest() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"C", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void testUnparseableNumerics() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        IncrementalIndexAddResult result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"19.0", (Object)"long", (Object)"asdj", (Object)"double", (Object)21.0)));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=19.0, long=asdj, double=21.0}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=19.0, long=asdj, double=21.0}], exceptions: [could not convert value [asdj] to long]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"aaa", (Object)"long", (Object)20, (Object)"double", (Object)21.0)));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=aaa, long=20, double=21.0}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=aaa, long=20, double=21.0}], exceptions: [could not convert value [aaa] to float]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)19.0, (Object)"long", (Object)20, (Object)"double", (Object)"")));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=19.0, long=20, double=}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=19.0, long=20, double=}], exceptions: [could not convert value [] to double]", (Object)result.getParseException().getMessage());
    }

    @Test
    public void sameRow() throws IndexSizeExceededException {
        MapBasedInputRow row = new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B"));
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)row);
        index.add((InputRow)row);
        index.add((InputRow)row);
        Assert.assertEquals((long)1L, (long)index.size());
    }
}

