/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.HashJoinSegmentStorageAdapter;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class HashJoinSegmentTest
extends InitializedNullHandlingTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private QueryableIndexSegment baseSegment;
    private ReferenceCountingSegment referencedSegment;
    private HashJoinSegment hashJoinSegment;
    private int allReferencesAcquireCount;
    private int allReferencesCloseCount;
    private int referencedSegmentAcquireCount;
    private int referencedSegmentClosedCount;
    private int indexedTableJoinableReferenceAcquireCount;
    private int indexedTableJoinableReferenceCloseCount;
    private boolean j0Closed;
    private boolean j1Closed;

    @Before
    public void setUp() throws IOException {
        this.allReferencesAcquireCount = 0;
        this.allReferencesCloseCount = 0;
        this.referencedSegmentAcquireCount = 0;
        this.referencedSegmentClosedCount = 0;
        this.indexedTableJoinableReferenceAcquireCount = 0;
        this.indexedTableJoinableReferenceCloseCount = 0;
        this.j0Closed = false;
        this.j1Closed = false;
        this.baseSegment = new QueryableIndexSegment(JoinTestHelper.createFactIndexBuilder(this.temporaryFolder.newFolder()).buildMMappedIndex(), SegmentId.dummy((String)"facts"));
        ImmutableList joinableClauses = ImmutableList.of((Object)new JoinableClause("j0.", (Joinable)new IndexedTableJoinable((IndexedTable)JoinTestHelper.createCountriesIndexedTable()){

            public Optional<Closeable> acquireReferences() {
                if (!HashJoinSegmentTest.this.j0Closed) {
                    HashJoinSegmentTest.this.indexedTableJoinableReferenceAcquireCount++;
                    Closer closer = Closer.create();
                    closer.register(() -> HashJoinSegmentTest.this.indexedTableJoinableReferenceCloseCount++);
                    return Optional.of(closer);
                }
                return Optional.empty();
            }
        }, JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"1", (String)"j0.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("j1.", (Joinable)new IndexedTableJoinable((IndexedTable)JoinTestHelper.createRegionsIndexedTable()){

            public Optional<Closeable> acquireReferences() {
                if (!HashJoinSegmentTest.this.j1Closed) {
                    HashJoinSegmentTest.this.indexedTableJoinableReferenceAcquireCount++;
                    Closer closer = Closer.create();
                    closer.register(() -> HashJoinSegmentTest.this.indexedTableJoinableReferenceCloseCount++);
                    return Optional.of(closer);
                }
                return Optional.empty();
            }
        }, JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"1", (String)"j1.", (ExprMacroTable)ExprMacroTable.nil())));
        this.referencedSegment = ReferenceCountingSegment.wrapRootGenerationSegment((Segment)this.baseSegment);
        SegmentReference testWrapper = new SegmentReference(){

            public Optional<Closeable> acquireReferences() {
                Closer closer = Closer.create();
                return HashJoinSegmentTest.this.referencedSegment.acquireReferences().map(closeable -> {
                    HashJoinSegmentTest.this.referencedSegmentAcquireCount++;
                    closer.register(closeable);
                    closer.register(() -> HashJoinSegmentTest.this.referencedSegmentClosedCount++);
                    return closer;
                });
            }

            public SegmentId getId() {
                return HashJoinSegmentTest.this.referencedSegment.getId();
            }

            public Interval getDataInterval() {
                return HashJoinSegmentTest.this.referencedSegment.getDataInterval();
            }

            @Nullable
            public QueryableIndex asQueryableIndex() {
                return HashJoinSegmentTest.this.referencedSegment.asQueryableIndex();
            }

            public StorageAdapter asStorageAdapter() {
                return HashJoinSegmentTest.this.referencedSegment.asStorageAdapter();
            }

            public void close() {
                HashJoinSegmentTest.this.referencedSegment.close();
            }
        };
        this.hashJoinSegment = new HashJoinSegment(testWrapper, null, (List)joinableClauses, null){

            public Optional<Closeable> acquireReferences() {
                Closer closer = Closer.create();
                return super.acquireReferences().map(closeable -> {
                    HashJoinSegmentTest.this.allReferencesAcquireCount++;
                    closer.register(closeable);
                    closer.register(() -> HashJoinSegmentTest.this.allReferencesCloseCount++);
                    return closer;
                });
            }
        };
    }

    @Test
    public void test_constructor_noClauses() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("'clauses' and 'baseFilter' are both empty, no need to create HashJoinSegment");
        ImmutableList joinableClauses = ImmutableList.of();
        HashJoinSegment ignored = new HashJoinSegment((SegmentReference)ReferenceCountingSegment.wrapRootGenerationSegment((Segment)this.baseSegment), null, (List)joinableClauses, null);
    }

    @Test
    public void test_getId() {
        Assert.assertEquals((Object)this.baseSegment.getId(), (Object)this.hashJoinSegment.getId());
    }

    @Test
    public void test_getDataInterval() {
        Assert.assertEquals((Object)this.baseSegment.getDataInterval(), (Object)this.hashJoinSegment.getDataInterval());
    }

    @Test
    public void test_asQueryableIndex() {
        Assert.assertNull((Object)this.hashJoinSegment.asQueryableIndex());
    }

    @Test
    public void test_asStorageAdapter() {
        Assert.assertThat((Object)this.hashJoinSegment.asStorageAdapter(), (Matcher)CoreMatchers.instanceOf(HashJoinSegmentStorageAdapter.class));
    }

    @Test
    public void testJoinableClausesAreClosedWhenReferencesUsed() throws IOException {
        Assert.assertFalse((boolean)this.referencedSegment.isClosed());
        Optional maybeCloseable = this.hashJoinSegment.acquireReferences();
        Assert.assertTrue((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)2L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)1L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)0L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
        Closeable closer = (Closeable)maybeCloseable.get();
        closer.close();
        Assert.assertFalse((boolean)this.referencedSegment.isClosed());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)2L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)1L, (long)this.allReferencesCloseCount);
    }

    @Test
    public void testJoinableClausesClosedIfSegmentIsAlreadyClosed() {
        Assert.assertFalse((boolean)this.referencedSegment.isClosed());
        this.referencedSegment.close();
        Assert.assertTrue((boolean)this.referencedSegment.isClosed());
        Optional maybeCloseable = this.hashJoinSegment.acquireReferences();
        Assert.assertFalse((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)0L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)0L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
    }

    @Test
    public void testJoinableClausesClosedIfJoinableZeroIsAlreadyClosed() {
        Assert.assertFalse((boolean)this.referencedSegment.isClosed());
        this.j0Closed = true;
        Optional maybeCloseable = this.hashJoinSegment.acquireReferences();
        Assert.assertFalse((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)1L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
    }

    @Test
    public void testJoinableClausesClosedIfJoinableOneIsAlreadyClosed() {
        Assert.assertFalse((boolean)this.referencedSegment.isClosed());
        this.j1Closed = true;
        Optional maybeCloseable = this.hashJoinSegment.acquireReferences();
        Assert.assertFalse((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)1L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)1L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)1L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
    }
}

