/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.BoundFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.join.BaseHashJoinSegmentStorageAdapterTest;
import org.apache.druid.segment.join.HashJoinSegmentStorageAdapter;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterAnalyzer;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.JoinFilterSplit;
import org.apache.druid.segment.join.filter.JoinableClauses;
import org.apache.druid.segment.join.filter.rewrite.JoinFilterRewriteConfig;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class JoinFilterAnalyzerTest
extends BaseHashJoinSegmentStorageAdapterTest {
    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnChannel() {
        SelectorFilter originalFilter = new SelectorFilter("channel", "#en.wikipedia");
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, null}, (Object)new Object[]{"Peremptory norm", "New South Wales", "Australia"}, (Object)new Object[]{"President of India", "California", "United States"}, (Object)new Object[]{"Glasgow", "Kingston upon Hull", "United Kingdom"}, (Object)new Object[]{"Otjiwarongo Airport", "California", "United States"}, (Object)new Object[]{"Sarah Michelle Gellar", "Ontario", "Canada"}, (Object)new Object[]{"DirecTV", "North Carolina", "United States"}, (Object)new Object[]{"Carlo Curti", "California", "United States"}, (Object)new Object[]{"Giusy Ferreri discography", "Provincia di Varese", "Italy"}, (Object)new Object[]{"Roma-Bangkok", "Provincia di Varese", "Italy"}, (Object)new Object[]{"Old Anatolian Turkish", "Virginia", "United States"}, (Object)new Object[]{"Cream Soda", "Ainigriv", "States United"}, (Object[])new Object[][]{{"Orange Soda", null, null}, {"History of Fourems", "Fourems Province", "Fourems"}}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new SelectorFilter("channel", "#en.wikipedia"), null, (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionExprToCountryLeftFilterOnCountryName() {
        SelectorFilter originalFilter = new SelectorFilter("rtc.countryName", "United States");
        JoinableClause regionExprToCountry = new JoinableClause("rtc.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"reverse(\"%scountryIsoCode\") == \"%scountryIsoCode\"", (Object[])new Object[]{"r1.", "rtc."}), (String)"rtc.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)regionExprToCountry);
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Cream Soda", "Ainigriv", "United States"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new SelectorFilter("rtc.countryName", "United States"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnChannelAndCountryName() {
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("rtc.countryName", "United States")));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"President of India", "California", "United States"}, (Object)new Object[]{"Otjiwarongo Airport", "California", "United States"}, (Object)new Object[]{"DirecTV", "North Carolina", "United States"}, (Object)new Object[]{"Carlo Curti", "California", "United States"}, (Object)new Object[]{"Old Anatolian Turkish", "Virginia", "United States"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"US")).toFilter())), (Filter)new SelectorFilter("rtc.countryName", "United States"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnNullColumns() {
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("countryIsoCode", null), (Object)new SelectorFilter("countryNumber", null), (Object)new SelectorFilter("rtc.countryName", null), (Object)new SelectorFilter("r1.regionName", null)));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, null}, (Object)new Object[]{"Rallicula", null, null}, (Object)new Object[]{"Apamea abruzzorum", null, null}, (Object)new Object[]{"Atractus flammigerus", null, null}, (Object)new Object[]{"Agama mossambica", null, null}) : ImmutableList.of()));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("countryIsoCode", null), (Object)new SelectorFilter("countryNumber", null), (Object)new SelectorFilter("rtc.countryName", null), (Object)new SelectorFilter("r1.regionName", null))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnInvalidColumns() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("baseTableInvalidColumn", "abcd"), (Object)new SelectorFilter("baseTableInvalidColumn2", null), (Object)new SelectorFilter("rtc.invalidColumn", "abcd"), (Object)new SelectorFilter("r1.invalidColumn", "abcd")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new SelectorFilter("baseTableInvalidColumn", "abcd"), (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("baseTableInvalidColumn2", null), (Object)new SelectorFilter("rtc.invalidColumn", "abcd"), (Object)new SelectorFilter("r1.invalidColumn", "abcd"))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnChannelVirtualColumn() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("v1", "virtual-column-#en.wikipedia")));
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v1", "concat('virtual-column-', \"channel\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, virtualColumns);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, virtualColumns, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, null}, (Object)new Object[]{"Peremptory norm", "New South Wales", "Australia"}, (Object)new Object[]{"President of India", "California", "United States"}, (Object)new Object[]{"Glasgow", "Kingston upon Hull", "United Kingdom"}, (Object)new Object[]{"Otjiwarongo Airport", "California", "United States"}, (Object)new Object[]{"Sarah Michelle Gellar", "Ontario", "Canada"}, (Object)new Object[]{"DirecTV", "North Carolina", "United States"}, (Object)new Object[]{"Carlo Curti", "California", "United States"}, (Object)new Object[]{"Giusy Ferreri discography", "Provincia di Varese", "Italy"}, (Object)new Object[]{"Roma-Bangkok", "Provincia di Varese", "Italy"}, (Object)new Object[]{"Old Anatolian Turkish", "Virginia", "United States"}, (Object)new Object[]{"Cream Soda", "Ainigriv", "States United"}, (Object[])new Object[][]{{"Orange Soda", null, null}, {"History of Fourems", "Fourems Province", "Fourems"}}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new SelectorFilter("v1", "virtual-column-#en.wikipedia"), null, (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionFilterOnRHSRegionNameExprVirtualColumn() {
        SelectorFilter originalFilter = new SelectorFilter("v0", "VIRGINIA");
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "upper(\"r1.regionName\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)));
        JoinableClauses joinableClauses = JoinableClauses.fromList((List)ImmutableList.of((Object)this.factToRegion(JoinType.LEFT)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, joinableClauses.getJoinableClauses(), virtualColumns);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), joinableClauses.getJoinableClauses(), joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, virtualColumns, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"v0"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Old Anatolian Turkish", "VIRGINIA"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new SelectorFilter("v0", "VIRGINIA"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterNormalizedAlreadyPushDownVariety() {
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#fr.wikipedia"), (Object)new BoundFilter(new BoundDimFilter("page", "Les Argonautes", "Les Argonautes", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)), (Object)new SelectorFilter("rtc.countryName", "Canada"), (Object)new BoundFilter(new BoundDimFilter("rtc.countryName", "Canada", "Canada", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("namespace", "main"), (Object)new BoundFilter(new BoundDimFilter("user", "24.122.168.111", "24.122.168.111", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("namespace", "main"), (Object)new BoundFilter(new BoundDimFilter("r1.regionName", "Quebec", "Quebec", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null))))));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Les Argonautes", "Quebec", "Canada"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#fr.wikipedia"), (Object)new BoundFilter(new BoundDimFilter("page", "Les Argonautes", "Les Argonautes", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("namespace", "main"), (Object)new BoundFilter(new BoundDimFilter("user", "24.122.168.111", "24.122.168.111", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"CA")).toFilter())), (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("rtc.countryName", "Canada"), (Object)new BoundFilter(new BoundDimFilter("rtc.countryName", "Canada", "Canada", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("namespace", "main"), (Object)new BoundFilter(new BoundDimFilter("r1.regionName", "Quebec", "Quebec", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factExpressionsToRegionToCountryLeftFilterOnChannelAndCountryName() {
        JoinableClause factExprToRegon = new JoinableClause("r1.", (Joinable)new IndexedTableJoinable(this.regionsTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == reverse(regionIsoCode) && \"%scountryIsoCode\" == reverse(countryIsoCode)", (Object[])new Object[]{"r1.", "r1."}), (String)"r1.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)factExprToRegon, (Object)this.regionToCountry(JoinType.LEFT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("rtc.countryName", "States United")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Old Anatolian Turkish", "Ainigriv", "States United"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new InDimFilter("JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-0", (Set)ImmutableSet.of((Object)"SU")).toFilter())), (Filter)new SelectorFilter("rtc.countryName", "States United"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        ExpressionVirtualColumn expectedVirtualColumn = new ExpressionVirtualColumn("JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-0", "reverse(countryIsoCode)", ColumnType.STRING, ExprMacroTable.nil());
        Assert.assertEquals((Object)expectedFilterSplit.getBaseTableFilter(), (Object)actualFilterSplit.getBaseTableFilter());
        Assert.assertEquals((Object)expectedFilterSplit.getJoinTableFilter(), (Object)actualFilterSplit.getJoinTableFilter());
        ExpressionVirtualColumn actualVirtualColumn = (ExpressionVirtualColumn)actualFilterSplit.getPushDownVirtualColumns().iterator().next();
        this.compareExpressionVirtualColumns(expectedVirtualColumn, actualVirtualColumn);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryNotEquiJoinLeftFilterOnChannelAndCountryName() {
        JoinableClause factExprToRegon = new JoinableClause("r1.", (Joinable)new IndexedTableJoinable(this.regionsTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == regionIsoCode && reverse(\"%scountryIsoCode\") == countryIsoCode", (Object[])new Object[]{"r1.", "r1."}), (String)"r1.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)factExprToRegon, (Object)this.regionToCountry(JoinType.LEFT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("rtc.countryName", "States United")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot build hash-join matcher on non-equi-join condition: \"r1.regionIsoCode\" == regionIsoCode && reverse(\"r1.countryIsoCode\") == countryIsoCode");
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Old Anatolian Turkish", "Ainigriv", "States United"}));
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftUnnormalizedFilter() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        OrFilter originalFilter = new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#ko.wikipedia"), (Object)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("rtc.countryName", "United States"), (Object)new SelectorFilter("r1.regionName", "Virginia")))));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"\uc720\ud76c\uc655 GX", "Seoul", "Republic of Korea"}, (Object)new Object[]{"Old Anatolian Turkish", "Virginia", "United States"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#ko.wikipedia"), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"US")).toFilter())), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#ko.wikipedia"), (Object)new AndFilter((List)ImmutableList.of((Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"US")).toFilter(), (Object)new InDimFilter("regionIsoCode", (Set)ImmutableSet.of((Object)"VA")).toFilter())))))), (Filter)new AndFilter((List)ImmutableList.of((Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#ko.wikipedia"), (Object)new SelectorFilter("rtc.countryName", "United States"))), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#ko.wikipedia"), (Object)new SelectorFilter("r1.regionName", "Virginia"))))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factConcatExpressionToCountryLeftFilterOnChannelAndCountryName() {
        JoinableClause factExprToCountry = new JoinableClause("c1.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%scountryIsoCode\" == concat(countryIsoCode, regionIsoCode)", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)factExprToCountry);
        AndFilter filter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("c1.countryName", "Usca")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)filter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"c1.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"President of India", "Usca"}, (Object)new Object[]{"Otjiwarongo Airport", "Usca"}, (Object)new Object[]{"Carlo Curti", "Usca"}));
        ExpressionVirtualColumn expectedVirtualColumn = new ExpressionVirtualColumn("JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-0", "concat(countryIsoCode, regionIsoCode)", ColumnType.STRING, ExprMacroTable.nil());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new InDimFilter("JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-0", (Set)ImmutableSet.of((Object)"USCA")).toFilter())), (Filter)new SelectorFilter("c1.countryName", "Usca"), (Set)ImmutableSet.of((Object)expectedVirtualColumn));
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit.getBaseTableFilter(), (Object)actualFilterSplit.getBaseTableFilter());
        Assert.assertEquals((Object)expectedFilterSplit.getJoinTableFilter(), (Object)actualFilterSplit.getJoinTableFilter());
        ExpressionVirtualColumn actualVirtualColumn = (ExpressionVirtualColumn)actualFilterSplit.getPushDownVirtualColumns().iterator().next();
        this.compareExpressionVirtualColumns(expectedVirtualColumn, actualVirtualColumn);
    }

    @Test
    public void test_filterPushDown_factConcatExpressionToCountryLeftFilterOnChannelAndCountryNameUsingLookup() {
        JoinableClause factExprToCountry = new JoinableClause("c1.", (Joinable)LookupJoinable.wrap((LookupExtractor)this.countryIsoCodeToNameLookup), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == concat(countryIsoCode, regionIsoCode)", (Object[])new Object[]{"c1."}), (String)"c1.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)factExprToCountry);
        AndFilter filter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("c1.v", "Usca")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)filter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"President of India", "Usca"}, (Object)new Object[]{"Otjiwarongo Airport", "Usca"}, (Object)new Object[]{"Carlo Curti", "Usca"}));
        ExpressionVirtualColumn expectedVirtualColumn = new ExpressionVirtualColumn("JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-0", "concat(countryIsoCode, regionIsoCode)", ColumnType.STRING, ExprMacroTable.nil());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new InDimFilter("JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-0", (Set)ImmutableSet.of((Object)"USCA")).toFilter())), (Filter)new SelectorFilter("c1.v", "Usca"), (Set)ImmutableSet.of((Object)expectedVirtualColumn));
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit.getBaseTableFilter(), (Object)actualFilterSplit.getBaseTableFilter());
        Assert.assertEquals((Object)expectedFilterSplit.getJoinTableFilter(), (Object)actualFilterSplit.getJoinTableFilter());
        ExpressionVirtualColumn actualVirtualColumn = (ExpressionVirtualColumn)actualFilterSplit.getPushDownVirtualColumns().iterator().next();
        this.compareExpressionVirtualColumns(expectedVirtualColumn, actualVirtualColumn);
    }

    @Test
    public void test_filterPushDown_factToCountryRightWithFilterOnChannelAndJoinable() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.RIGHT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#de.wikipedia"), (Object)new SelectorFilter("c1.countryName", "Germany")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", 3L, "DE", "Germany", 3L}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#de.wikipedia"), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"DE")).toFilter())), (Filter)new SelectorFilter("c1.countryName", "Germany"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryRightWithFilterOnChannelAndJoinableUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.RIGHT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#de.wikipedia"), (Object)new SelectorFilter("c1.v", "Germany")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Diskussion:Sebastian Schulz", "DE", 3L, "DE", "Germany"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#de.wikipedia"), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"DE")).toFilter())), (Filter)new SelectorFilter("c1.v", "Germany"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryRightWithFilterOnNullColumns() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.RIGHT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.countryName", null)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.countryName", null))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryRightWithFilterOnValueThatMatchesNothing() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.RIGHT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.countryName", "NO MATCH")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)FalseFilter.instance(), (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.countryName", "NO MATCH"))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryRightWithFilterOnNullColumnsUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.RIGHT));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.v", null)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.v", null))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryInnerUsingCountryNumberFilterOnChannelAndCountryName() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnNumber(JoinType.INNER));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("c2.countryName", "Australia")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c2.countryIsoCode", (Object)"c2.countryName", (Object)"c2.countryNumber"), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia", 0L}) : ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, "AU", "Australia", 0L}, (Object)new Object[]{"Peremptory norm", "AU", "AU", "Australia", 0L})));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new InDimFilter("countryNumber", (Set)ImmutableSet.of((Object)"0")).toFilter())), (Filter)new SelectorFilter("c2.countryName", "Australia"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryInnerUsingCountryNumberFilterOnChannelAndCountryNameUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingNumberLookup(JoinType.INNER));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("c2.v", "Australia")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c2.k", (Object)"c2.v"), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{"Peremptory norm", "AU", "0", "Australia"}) : ImmutableList.of((Object)new Object[]{"Talk:Oswald Tilghman", null, "0", "Australia"}, (Object)new Object[]{"Peremptory norm", "AU", "0", "Australia"})));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new InDimFilter("countryNumber", (Set)ImmutableSet.of((Object)"0")).toFilter())), (Filter)new SelectorFilter("c2.v", "Australia"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryInnerUsingCountryNumberFilterOnNulls() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnNumber(JoinType.INNER));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c2.countryName", null)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c2.countryIsoCode", (Object)"c2.countryName", (Object)"c2.countryNumber"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c2.countryName", null))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryInnerUsingCountryNumberFilterOnNullsUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.INNER));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c2.v", null)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"c2.k", (Object)"c2.v"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c2.v", null))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryFullWithFilterOnChannelAndCountryName() {
        AndFilter filter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#es.wikipedia"), (Object)new SelectorFilter("c1.countryName", "El Salvador")));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.FULL));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)filter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Wendigo", "SV", 12L, "SV", "El Salvador", 12L}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#es.wikipedia"), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"SV")).toFilter())), (Filter)new SelectorFilter("c1.countryName", "El Salvador"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryFullWithFilterOnChannelAndCountryNameUsingLookup() {
        AndFilter filter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#es.wikipedia"), (Object)new SelectorFilter("c1.v", "El Salvador")));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.FULL));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)filter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)filter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Wendigo", "SV", 12L, "SV", "El Salvador"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#es.wikipedia"), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"SV")).toFilter())), (Filter)new SelectorFilter("c1.v", "El Salvador"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryFullWithFilterOnNulls() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.FULL));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.countryName", null)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.countryIsoCode", (Object)"c1.countryName", (Object)"c1.countryNumber"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.countryName", null))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToCountryFullWithFilterOnNullsUsingLookup() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryNameUsingIsoCodeLookup(JoinType.FULL));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.v", null)));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"countryIsoCode", (Object)"countryNumber", (Object)"c1.k", (Object)"c1.v"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", null), (Object)new SelectorFilter("c1.v", null))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionTwoColumnsToOneRHSColumnAndFilterOnRHS() {
        JoinableClause factExprToRegon = new JoinableClause("r1.", (Joinable)new IndexedTableJoinable(this.regionsTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == regionIsoCode && \"%sregionIsoCode\" == countryIsoCode", (Object[])new Object[]{"r1.", "r1."}), (String)"r1.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)factExprToRegon);
        SelectorFilter originalFilter = new SelectorFilter("r1.regionName", "Fourems Province");
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"History of Fourems", "Fourems Province"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"MMMM")).toFilter(), (Object)new InDimFilter("regionIsoCode", (Set)ImmutableSet.of((Object)"MMMM")).toFilter())), (Filter)new SelectorFilter("r1.regionName", "Fourems Province"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionOneColumnToTwoRHSColumnsAndFilterOnRHS() {
        JoinableClause factExprToRegon = new JoinableClause("r1.", (Joinable)new IndexedTableJoinable(this.regionsTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == regionIsoCode && \"%scountryIsoCode\" == regionIsoCode", (Object[])new Object[]{"r1.", "r1."}), (String)"r1.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)factExprToRegon);
        OrFilter originalFilter = new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("r1.regionName", "Fourems Province"), (Object)new SelectorFilter("r1.regionIsoCode", "AAAA")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"History of Fourems", "Fourems Province"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new OrFilter((List)ImmutableList.of((Object)new InDimFilter("regionIsoCode", (Set)ImmutableSet.of((Object)"MMMM")).toFilter(), (Object)new SelectorFilter("regionIsoCode", "AAAA"))), (Filter)originalFilter, (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionThreeRHSColumnsAllDirectAndFilterOnRHS() {
        JoinableClause factExprToRegon = new JoinableClause("r1.", (Joinable)new IndexedTableJoinable(this.regionsTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == regionIsoCode && \"%scountryIsoCode\" == regionIsoCode && \"%sregionName\" == user", (Object[])new Object[]{"r1.", "r1.", "r1."}), (String)"r1.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)factExprToRegon);
        OrFilter originalFilter = new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("r1.regionName", "Fourems Province"), (Object)new SelectorFilter("r1.regionIsoCode", "AAAA")));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Cannot build hash-join matcher on non-key-based condition: Equality{leftExpr=user, rightColumn='regionName'}");
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("user", "Fourems Province"), (Object)new SelectorFilter("regionIsoCode", "AAAA"))), null, (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnPageDisablePushDown() {
        JoinableClauses joinableClauses = JoinableClauses.fromList((List)ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT)));
        SelectorFilter originalFilter = new SelectorFilter("page", "Peremptory norm");
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzer.computeJoinFilterPreAnalysis((JoinFilterPreAnalysisKey)new JoinFilterPreAnalysisKey(new JoinFilterRewriteConfig(false, true, true, true, 10000L), joinableClauses.getJoinableClauses(), VirtualColumns.EMPTY, (Filter)originalFilter));
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), joinableClauses.getJoinableClauses(), joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Peremptory norm", "New South Wales", "Australia"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new SelectorFilter("page", "Peremptory norm"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftEnablePushDownDisableRewrite() {
        JoinableClauses joinableClauses = JoinableClauses.fromList((List)ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT)));
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new SelectorFilter("rtc.countryName", "United States"), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("page", "DirecTV"), (Object)new SelectorFilter("rtc.countryIsoCode", "US"))), (Object)new BoundFilter(new BoundDimFilter("namespace", "Main", "Main", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null))));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzer.computeJoinFilterPreAnalysis((JoinFilterPreAnalysisKey)new JoinFilterPreAnalysisKey(new JoinFilterRewriteConfig(true, false, true, true, 10000L), joinableClauses.getJoinableClauses(), VirtualColumns.EMPTY, (Filter)originalFilter));
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), joinableClauses.getJoinableClauses(), joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"President of India", "California", "United States"}, (Object)new Object[]{"Otjiwarongo Airport", "California", "United States"}, (Object)new Object[]{"DirecTV", "North Carolina", "United States"}, (Object)new Object[]{"Carlo Curti", "California", "United States"}, (Object)new Object[]{"Old Anatolian Turkish", "Virginia", "United States"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#en.wikipedia"), (Object)new BoundFilter(new BoundDimFilter("namespace", "Main", "Main", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))), (Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("rtc.countryName", "United States"), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("page", "DirecTV"), (Object)new SelectorFilter("rtc.countryIsoCode", "US"))))), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnRHSJoinConditionColumns() {
        this.test_filterPushDown_factToRegionToCountryLeftFilterOnRHSJoinConditionColumnsHelper(false);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnRHSJoinConditionColumnsWithLhsExpr() {
        this.test_filterPushDown_factToRegionToCountryLeftFilterOnRHSJoinConditionColumnsHelper(true);
    }

    private void test_filterPushDown_factToRegionToCountryLeftFilterOnRHSJoinConditionColumnsHelper(boolean hasLhsExpressionInJoinCondition) {
        Filter expressionFilter = new ExpressionDimFilter("\"rtc.countryIsoCode\" == 'CA'", ExprMacroTable.nil()).toFilter();
        SelectorFilter specialSelectorFilter = new SelectorFilter("rtc.countryIsoCode", "CA"){

            public boolean supportsRequiredColumnRewrite() {
                return false;
            }
        };
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("r1.regionIsoCode", "ON"), (Object)new SelectorFilter("rtc.countryIsoCode", "CA"), (Object)specialSelectorFilter, (Object)new BoundFilter(new BoundDimFilter("rtc.countryIsoCode", "CA", "CB", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)), (Object)expressionFilter, (Object)new InDimFilter("rtc.countryIsoCode", (Set)ImmutableSet.of((Object)"CA", (Object)"CA2", (Object)"CA3")).toFilter(), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#fr.wikipedia"), (Object)new SelectorFilter("rtc.countryIsoCode", "QQQ"), (Object)new BoundFilter(new BoundDimFilter("rtc.countryIsoCode", "YYY", "ZZZ", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("namespace", "Main"), (Object)new SelectorFilter("rtc.countryIsoCode", "ABCDEF"), (Object)new SelectorFilter("rtc.countryName", "Canada"), (Object)new BoundFilter(new BoundDimFilter("rtc.countryIsoCode", "XYZXYZ", "XYZXYZ", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null))))));
        JoinableClause factToRegionClause = hasLhsExpressionInJoinCondition ? new JoinableClause("r1.", (Joinable)new IndexedTableJoinable(this.regionsTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sregionIsoCode\" == upper(lower(regionIsoCode)) && \"%scountryIsoCode\" == upper(lower(countryIsoCode))", (Object[])new Object[]{"r1.", "r1."}), (String)"r1.", (ExprMacroTable)ExprMacroTable.nil())) : this.factToRegion(JoinType.LEFT);
        ImmutableList joinableClauses = ImmutableList.of((Object)factToRegionClause, (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        String rewrittenCountryIsoCodeColumnName = hasLhsExpressionInJoinCondition ? "JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-1" : "countryIsoCode";
        String rewrittenRegionIsoCodeColumnName = hasLhsExpressionInJoinCondition ? "JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-0" : "regionIsoCode";
        ImmutableSet expectedVirtualColumns = hasLhsExpressionInJoinCondition ? ImmutableSet.of((Object)new ExpressionVirtualColumn(rewrittenRegionIsoCodeColumnName, "(upper [(lower [regionIsoCode])])", ColumnType.STRING, ExprMacroTable.nil()), (Object)new ExpressionVirtualColumn(rewrittenCountryIsoCodeColumnName, "(upper [(lower [countryIsoCode])])", ColumnType.STRING, ExprMacroTable.nil())) : ImmutableSet.of();
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Didier Leclair", "Ontario", "Canada"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new SelectorFilter(rewrittenRegionIsoCodeColumnName, "ON"), (Object)new SelectorFilter(rewrittenCountryIsoCodeColumnName, "CA"), (Object)new InDimFilter(rewrittenCountryIsoCodeColumnName, (Set)ImmutableSet.of((Object)"CA")).toFilter(), (Object)new BoundFilter(new BoundDimFilter(rewrittenCountryIsoCodeColumnName, "CA", "CB", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)), (Object)new InDimFilter(rewrittenCountryIsoCodeColumnName, (Set)ImmutableSet.of((Object)"CA", (Object)"CA2", (Object)"CA3")).toFilter(), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("channel", "#fr.wikipedia"), (Object)new SelectorFilter(rewrittenCountryIsoCodeColumnName, "QQQ"), (Object)new BoundFilter(new BoundDimFilter(rewrittenCountryIsoCodeColumnName, "YYY", "ZZZ", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))), (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("namespace", "Main"), (Object)new SelectorFilter(rewrittenCountryIsoCodeColumnName, "ABCDEF"), (Object)new InDimFilter(rewrittenCountryIsoCodeColumnName, (Set)ImmutableSet.of((Object)"CA")).toFilter(), (Object)new BoundFilter(new BoundDimFilter(rewrittenCountryIsoCodeColumnName, "XYZXYZ", "XYZXYZ", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))))), (Filter)new AndFilter((List)ImmutableList.of((Object)specialSelectorFilter, (Object)expressionFilter, (Object)new OrFilter((List)ImmutableList.of((Object)new SelectorFilter("namespace", "Main"), (Object)new SelectorFilter("rtc.countryIsoCode", "ABCDEF"), (Object)new SelectorFilter("rtc.countryName", "Canada"), (Object)new BoundFilter(new BoundDimFilter("rtc.countryIsoCode", "XYZXYZ", "XYZXYZ", Boolean.valueOf(false), Boolean.valueOf(false), null, null, null)))))), (Set)expectedVirtualColumns);
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionToCountryLeftFilterOnTwoRHSColumnsSameValue() {
        AndFilter originalFilter = new AndFilter((List)ImmutableList.of((Object)new SelectorFilter("r1.regionName", "California"), (Object)new SelectorFilter("r1.extraField", "California")));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of());
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit((Filter)new AndFilter((List)ImmutableList.of((Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"US")).toFilter(), (Object)new InDimFilter("regionIsoCode", (Set)ImmutableSet.of((Object)"CA")).toFilter(), (Object)new InDimFilter("countryIsoCode", (Set)ImmutableSet.of((Object)"MMMM", (Object)"AAAA")).toFilter(), (Object)new InDimFilter("regionIsoCode", (Set)ImmutableSet.of((Object)"MMMM", (Object)"AAAA")).toFilter())), (Filter)originalFilter, (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_filterPushDown_factToRegionExprToCountryLeftFilterOnCountryNameWithMultiLevelMode() {
        SelectorFilter originalFilter = new SelectorFilter("rtc.countryName", "United States");
        JoinableClause regionExprToCountry = new JoinableClause("rtc.", (Joinable)new IndexedTableJoinable(this.countriesTable), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"reverse(\"%scountryIsoCode\") == \"%scountryIsoCode\"", (Object[])new Object[]{"r1.", "rtc."}), (String)"rtc.", (ExprMacroTable)ExprMacroTable.nil()));
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)regionExprToCountry);
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzer.computeJoinFilterPreAnalysis((JoinFilterPreAnalysisKey)new JoinFilterPreAnalysisKey(new JoinFilterRewriteConfig(true, true, true, true, 10000L), (List)joinableClauses, VirtualColumns.EMPTY, (Filter)originalFilter));
        HashJoinSegmentStorageAdapter adapter = new HashJoinSegmentStorageAdapter(this.factSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        JoinTestHelper.verifyCursors((Sequence<Cursor>)adapter.makeCursors((Filter)originalFilter, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null), (List<String>)ImmutableList.of((Object)"page", (Object)"r1.regionName", (Object)"rtc.countryName"), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Cream Soda", "Ainigriv", "United States"}));
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(null, (Filter)new SelectorFilter("rtc.countryName", "United States"), (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }

    @Test
    public void test_JoinFilterSplit_equals() {
        EqualsVerifier.forClass(JoinFilterSplit.class).usingGetClass().withNonnullFields(new String[]{"baseTableFilter", "pushDownVirtualColumns"}).verify();
    }

    @Test
    public void test_joinFilterPreAnalysisKey_equals() {
        EqualsVerifier.forClass(JoinFilterPreAnalysisKey.class).usingGetClass().withNonnullFields(new String[]{"virtualColumns"}).verify();
    }

    @Test
    public void test_filterPushDown_baseTableFilter() {
        SelectorFilter originalFilter = new SelectorFilter("channel", "#en.wikipedia");
        SelectorFilter baseTableFilter = new SelectorFilter("countryIsoCode", "CA");
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToRegion(JoinType.LEFT), (Object)this.regionToCountry(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzerTest.makeDefaultConfigPreAnalysis((Filter)originalFilter, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        JoinFilterSplit expectedFilterSplit = new JoinFilterSplit(Filters.and(Arrays.asList(originalFilter, baseTableFilter)), null, (Set)ImmutableSet.of());
        JoinFilterSplit actualFilterSplit = JoinFilterAnalyzer.splitFilter((JoinFilterPreAnalysis)joinFilterPreAnalysis, (Filter)baseTableFilter);
        Assert.assertEquals((Object)expectedFilterSplit, (Object)actualFilterSplit);
    }
}

