/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.virtual.ExpressionVectorObjectSelector;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionVectorObjectSelectorTest {
    private static final int MAX_SIZE = 8;
    private Expr.VectorInputBinding binding;
    private ExprVectorProcessor vectorProcessor;
    private ExpressionVectorObjectSelector expressionVectorValueSelector;

    @Before
    public void setUp() {
        this.binding = (Expr.VectorInputBinding)EasyMock.createMock(Expr.VectorInputBinding.class);
        this.vectorProcessor = (ExprVectorProcessor)EasyMock.createMock(ExprVectorProcessor.class);
        EasyMock.expect((Object)this.binding.getMaxVectorSize()).andReturn((Object)8).once();
        EasyMock.replay((Object[])new Object[]{this.binding, this.vectorProcessor});
        this.expressionVectorValueSelector = new ExpressionVectorObjectSelector(this.vectorProcessor, this.binding);
        EasyMock.reset((Object[])new Object[]{this.binding, this.vectorProcessor});
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.binding, this.vectorProcessor});
    }

    @Test
    public void testSelectObject() {
        Object[] vector = new String[]{"1", "2", null, "3"};
        ExprEvalObjectVector vectorEval = new ExprEvalObjectVector(vector);
        EasyMock.expect((Object)this.binding.getCurrentVectorId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.vectorProcessor.evalVector(this.binding)).andReturn((Object)vectorEval).once();
        EasyMock.replay((Object[])new Object[]{this.binding, this.vectorProcessor});
        Object[] vector1 = this.expressionVectorValueSelector.getObjectVector();
        Object[] vector2 = this.expressionVectorValueSelector.getObjectVector();
        Assert.assertArrayEquals((Object[])vector1, (Object[])vector2);
    }
}

