/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DeprecatedQueryableIndexColumnSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExpressionVectorSelectorsTest
extends InitializedNullHandlingTest {
    private static List<String> EXPRESSIONS = ImmutableList.of((Object)"long1 * long2", (Object)"long1 * nonexistent", (Object)"double1 * double3", (Object)"float1 + float3", (Object)"(long1 - long4) / double3", (Object)"long5 * float3 * long1 * long4 * double1", (Object)"long5 * double3 * long1 * long4 * double1", (Object)"max(double3, double5)", (Object)"max(nonexistent, double5)", (Object)"min(double4, double1)", (Object)"cos(float3)", (Object)"sin(long4)", (Object[])new String[]{"parse_long(string1)", "parse_long(nonexistent)", "parse_long(string1) * double3", "parse_long(string5) * parse_long(string1)", "parse_long(string5) * parse_long(string1) * double3", "'string constant'", "1", "192412.24124", "null", "long2", "float2", "double2", "string3", "string1 + string3", "concat(string1, string2, string3)", "concat(string1, 'x')", "concat(string1, nonexistent)"});
    private static final int ROWS_PER_SEGMENT = 10000;
    private static QueryableIndex INDEX;
    private static Closer CLOSER;
    private ExpressionType outputType;
    private String expression;

    @BeforeClass
    public static void setupClass() {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        INDEX = (QueryableIndex)CLOSER.register((Closeable)segmentGenerator.generate(dataSegment, schemaInfo, Granularities.HOUR, 10000));
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        CLOSER.close();
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="expression = {0}")
    public static Iterable<?> constructorFeeder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ExpressionVectorSelectorsTest(String expression) {
        this.expression = expression;
    }

    @Before
    public void setup() {
        Expr parsed = Parser.parse((String)this.expression, (ExprMacroTable)ExprMacroTable.nil());
        this.outputType = parsed.getOutputType((Expr.InputBindingInspector)new DeprecatedQueryableIndexColumnSelector(INDEX));
        if (this.outputType == null) {
            this.outputType = ExpressionType.STRING;
        }
    }

    @Test
    public void sanityTestVectorizedExpressionSelector() {
        ExpressionVectorSelectorsTest.sanityTestVectorizedExpressionSelectors(this.expression, this.outputType, INDEX, CLOSER, 10000);
    }

    public static void sanityTestVectorizedExpressionSelectors(String expression, @Nullable ExpressionType outputType, QueryableIndex index, Closer closer, int rowsPerSegment) {
        SingleValueDimensionVectorSelector selector;
        ArrayList<Object> results = new ArrayList<Object>(rowsPerSegment);
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v", expression, ExpressionType.toColumnType((ExpressionType)outputType), TestExprMacroTable.INSTANCE)));
        QueryableIndexStorageAdapter storageAdapter = new QueryableIndexStorageAdapter(index);
        VectorCursor cursor = storageAdapter.makeVectorCursor(null, index.getDataInterval(), virtualColumns, false, 512, null);
        ColumnCapabilities capabilities = virtualColumns.getColumnCapabilities((ColumnInspector)storageAdapter, "v");
        int rowCount = 0;
        if (capabilities.isDictionaryEncoded().isTrue()) {
            selector = cursor.getColumnSelectorFactory().makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"v"));
            while (!cursor.isDone()) {
                int[] row = selector.getRowVector();
                int i = 0;
                while (i < selector.getCurrentVectorSize()) {
                    results.add(selector.lookupName(row[i]));
                    ++i;
                    ++rowCount;
                }
                cursor.advance();
            }
        } else {
            selector = null;
            VectorObjectSelector objectSelector = null;
            if (outputType != null && outputType.isNumeric()) {
                selector = cursor.getColumnSelectorFactory().makeValueSelector("v");
            } else {
                objectSelector = cursor.getColumnSelectorFactory().makeObjectSelector("v");
            }
            while (!cursor.isDone()) {
                switch ((ExprType)outputType.getType()) {
                    case LONG: {
                        boolean[] nulls = selector.getNullVector();
                        long[] longs = selector.getLongVector();
                        int i = 0;
                        while (i < selector.getCurrentVectorSize()) {
                            results.add(nulls != null && nulls[i] ? null : Long.valueOf(longs[i]));
                            ++i;
                            ++rowCount;
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i;
                        boolean[] nulls;
                        if ("float2".equals(expression)) {
                            nulls = selector.getNullVector();
                            float[] floats = selector.getFloatVector();
                            i = 0;
                            while (i < selector.getCurrentVectorSize()) {
                                results.add(nulls != null && nulls[i] ? null : Double.valueOf(floats[i]));
                                ++i;
                                ++rowCount;
                            }
                        } else {
                            nulls = selector.getNullVector();
                            double[] doubles = selector.getDoubleVector();
                            i = 0;
                            while (i < selector.getCurrentVectorSize()) {
                                results.add(nulls != null && nulls[i] ? null : Double.valueOf(doubles[i]));
                                ++i;
                                ++rowCount;
                            }
                        }
                        break;
                    }
                    case STRING: {
                        Object[] objects = objectSelector.getObjectVector();
                        int i = 0;
                        while (i < objectSelector.getCurrentVectorSize()) {
                            results.add(objects[i]);
                            ++i;
                            ++rowCount;
                        }
                        break;
                    }
                }
                cursor.advance();
            }
        }
        closer.register((Closeable)cursor);
        Sequence cursors = new QueryableIndexStorageAdapter(index).makeCursors(null, index.getDataInterval(), virtualColumns, Granularities.ALL, false, null);
        int rowCountCursor = (Integer)cursors.map(nonVectorized -> {
            ColumnValueSelector nonSelector = nonVectorized.getColumnSelectorFactory().makeColumnValueSelector("v");
            int rows = 0;
            while (!nonVectorized.isDone()) {
                Assert.assertEquals((String)("Failed at row " + rows), (Object)nonSelector.getObject(), results.get(rows));
                ++rows;
                nonVectorized.advance();
            }
            return rows;
        }).accumulate((Object)0, (acc, in) -> acc + in);
        Assert.assertTrue((rowCountCursor > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)rowCountCursor, (long)rowCount);
    }
}

