/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class ComplexFieldReader
implements FieldReader {
    private final ComplexMetricSerde serde;

    ComplexFieldReader(ComplexMetricSerde serde) {
        this.serde = (ComplexMetricSerde)Preconditions.checkNotNull((Object)serde, (Object)"serde");
    }

    public static ComplexFieldReader createFromType(ColumnType columnType) {
        if (columnType == null || columnType.getType() != ValueType.COMPLEX || columnType.getComplexTypeName() == null) {
            throw new ISE("Expected complex type with defined complexTypeName, but got [%s]", new Object[]{columnType});
        }
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(columnType.getComplexTypeName());
        if (serde == null) {
            throw new ISE("No serde for complexTypeName[%s]", new Object[]{columnType.getComplexTypeName()});
        }
        return new ComplexFieldReader(serde);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return new Selector(memory, fieldPointer, this.serde);
    }

    @Override
    public DimensionSelector makeDimensionSelector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn) {
        return DimensionSelector.constant(null, extractionFn);
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    private static class Selector<T>
    extends ObjectColumnSelector<T> {
        private final Memory memory;
        private final ReadableFieldPointer fieldPointer;
        private final ComplexMetricSerde serde;

        private Selector(Memory memory, ReadableFieldPointer fieldPointer, ComplexMetricSerde serde) {
            this.memory = memory;
            this.fieldPointer = fieldPointer;
            this.serde = serde;
        }

        @Override
        @Nullable
        public T getObject() {
            long fieldPosition = this.fieldPointer.position();
            byte nullByte = this.memory.getByte(fieldPosition);
            if (nullByte == 0) {
                return null;
            }
            if (nullByte == 1) {
                int length = this.memory.getInt(fieldPosition + 1L);
                byte[] bytes = new byte[length];
                this.memory.getByteArray(fieldPosition + 5L, bytes, 0, length);
                return (T)this.serde.fromBytes(bytes, 0, length);
            }
            throw new ISE("Unexpected null byte [%s]", new Object[]{nullByte});
        }

        @Override
        public Class<T> classOfObject() {
            return this.serde.getExtractor().extractedClass();
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

