/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleFieldWriter
implements FieldWriter {
    public static final int SIZE = 9;
    public static final byte NULL_BYTE = 0;
    public static final byte NOT_NULL_BYTE = 1;
    private final BaseDoubleColumnValueSelector selector;

    public DoubleFieldWriter(BaseDoubleColumnValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public long writeTo(WritableMemory memory, long position, long maxSize) {
        if (maxSize < 9L) {
            return -1L;
        }
        if (this.selector.isNull()) {
            memory.putByte(position, (byte)0);
            memory.putLong(position + 1L, DoubleFieldWriter.transform(0.0));
        } else {
            memory.putByte(position, (byte)1);
            memory.putLong(position + 1L, DoubleFieldWriter.transform(this.selector.getDouble()));
        }
        return 9L;
    }

    @Override
    public void close() {
    }

    public static long transform(double n) {
        long bits = Double.doubleToLongBits(n);
        long mask = (bits & Long.MIN_VALUE) >> 11 | Long.MIN_VALUE;
        return Long.reverseBytes(bits ^ mask);
    }

    public static double detransform(long bits) {
        long reversedBits = Long.reverseBytes(bits);
        long mask = ((reversedBits ^ Long.MIN_VALUE) & Long.MIN_VALUE) >> 11 | Long.MIN_VALUE;
        return Double.longBitsToDouble(reversedBits ^ mask);
    }
}

