/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.base.Preconditions;
import org.apache.druid.frame.field.ComplexFieldReader;
import org.apache.druid.frame.field.DoubleFieldReader;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FloatFieldReader;
import org.apache.druid.frame.field.LongFieldReader;
import org.apache.druid.frame.field.StringFieldReader;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class FieldReaders {
    private FieldReaders() {
    }

    public static FieldReader create(String columnName, ColumnType columnType) {
        switch ((ValueType)((ColumnType)Preconditions.checkNotNull((Object)columnType, (Object)"columnType")).getType()) {
            case LONG: {
                return new LongFieldReader();
            }
            case FLOAT: {
                return new FloatFieldReader();
            }
            case DOUBLE: {
                return new DoubleFieldReader();
            }
            case STRING: {
                return new StringFieldReader(false);
            }
            case COMPLEX: {
                return ComplexFieldReader.createFromType(columnType);
            }
            case ARRAY: {
                if (columnType.getElementType().getType() != ValueType.STRING) break;
                return new StringFieldReader(true);
            }
        }
        throw new UnsupportedColumnTypeException(columnName, columnType);
    }
}

