/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;

public class BlockingQueueOutputChannelFactory
implements OutputChannelFactory {
    private final int frameSize;

    public BlockingQueueOutputChannelFactory(int frameSize) {
        this.frameSize = frameSize;
    }

    @Override
    public OutputChannel openChannel(int partitionNumber) {
        BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
        return OutputChannel.pair(channel.writable(), ArenaMemoryAllocator.createOnHeap(this.frameSize), channel::readable, partitionNumber);
    }

    @Override
    public OutputChannel openNilChannel(int partitionNumber) {
        return OutputChannel.nil(partitionNumber);
    }
}

