/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class OutputChannel {
    @Nullable
    private final WritableFrameChannel writableChannel;
    @Nullable
    private final MemoryAllocator frameMemoryAllocator;
    private final Supplier<ReadableFrameChannel> readableChannelSupplier;
    private final int partitionNumber;

    private OutputChannel(@Nullable WritableFrameChannel writableChannel, @Nullable MemoryAllocator frameMemoryAllocator, Supplier<ReadableFrameChannel> readableChannelSupplier, int partitionNumber) {
        this.writableChannel = writableChannel;
        this.frameMemoryAllocator = frameMemoryAllocator;
        this.readableChannelSupplier = readableChannelSupplier;
        this.partitionNumber = partitionNumber;
        if (partitionNumber < 0 && partitionNumber != -1) {
            throw new IAE("Invalid partition number [%d]", new Object[]{partitionNumber});
        }
    }

    public static OutputChannel pair(WritableFrameChannel writableChannel, MemoryAllocator frameMemoryAllocator, Supplier<ReadableFrameChannel> readableChannelSupplier, int partitionNumber) {
        return new OutputChannel((WritableFrameChannel)Preconditions.checkNotNull((Object)writableChannel, (Object)"writableChannel"), (MemoryAllocator)Preconditions.checkNotNull((Object)frameMemoryAllocator, (Object)"frameMemoryAllocator"), readableChannelSupplier, partitionNumber);
    }

    public static OutputChannel nil(int partitionNumber) {
        return new OutputChannel(null, null, () -> ReadableNilFrameChannel.INSTANCE, partitionNumber);
    }

    public WritableFrameChannel getWritableChannel() {
        if (this.writableChannel == null) {
            throw new ISE("Writable channel is not available", new Object[0]);
        }
        return this.writableChannel;
    }

    public MemoryAllocator getFrameMemoryAllocator() {
        if (this.frameMemoryAllocator == null) {
            throw new ISE("Writable channel is not available", new Object[0]);
        }
        return this.frameMemoryAllocator;
    }

    public ReadableFrameChannel getReadableChannel() {
        return this.readableChannelSupplier.get();
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public OutputChannel mapWritableChannel(Function<WritableFrameChannel, WritableFrameChannel> mapFn) {
        if (this.writableChannel == null) {
            return this;
        }
        return new OutputChannel(mapFn.apply(this.writableChannel), this.frameMemoryAllocator, this.readableChannelSupplier, this.partitionNumber);
    }

    public OutputChannel readOnly() {
        return new OutputChannel(null, null, this.readableChannelSupplier, this.partitionNumber);
    }
}

