/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.frame.processor.SuperSorterProgressSnapshot;
import org.apache.druid.java.util.common.ISE;

public class SuperSorterProgressTracker {
    private int totalMergingLevels = -1;
    private long totalMergersForUltimateLevel = -1L;
    private final Map<Integer, Long> levelToTotalBatches;
    private final Map<Integer, Long> levelToMergedBatches = new HashMap<Integer, Long>();
    private boolean isTriviallyComplete = false;
    private static final SuperSorterProgressSnapshot TRIVIALLY_COMPLETE_SNAPSHOT = new SuperSorterProgressSnapshot(-1, Collections.emptyMap(), Collections.emptyMap(), -1L, true);

    public SuperSorterProgressTracker() {
        this.levelToTotalBatches = new HashMap<Integer, Long>();
    }

    public synchronized void setTotalMergingLevels(int totalMergingLevels) {
        if (this.totalMergingLevels != -1) {
            throw new ISE("Total merging levels already defined for the merge sort.", new Object[0]);
        }
        this.levelToMergedBatches.keySet().stream().max(Ordering.natural()).ifPresent(max -> {
            if (max >= totalMergingLevels) {
                throw new ISE("Max level found in levelToMergedBatches is %d (0-indexed). Cannot set totalMergingLevels to %d", new Object[]{max, totalMergingLevels});
            }
        });
        this.levelToTotalBatches.keySet().stream().max(Ordering.natural()).ifPresent(max -> {
            if (max >= totalMergingLevels) {
                throw new ISE("Max level found in levelToTotalBatches is %d (0-indexed). Cannot set totalMergingLevels to %d", new Object[]{max, totalMergingLevels});
            }
        });
        this.totalMergingLevels = totalMergingLevels;
    }

    public synchronized void setTotalMergersForLevel(int level, long totalMergers) {
        if (level < 0) {
            throw new ISE("Unable to set %d total mergers for level %d. Level must be non-negative", new Object[]{totalMergers, level});
        }
        if (this.totalMergingLevels != -1 && level >= this.totalMergingLevels) {
            throw new ISE("Cannot set total mergers for level %d. Valid levels range from 0 to %d", new Object[]{level, this.totalMergingLevels - 1});
        }
        if (this.totalMergingLevels != -1 && level < this.totalMergingLevels - 1 && this.levelToTotalBatches.containsKey(level)) {
            throw new ISE("Total mergers are already present for the level %d", new Object[]{level});
        }
        this.levelToTotalBatches.put(level, totalMergers);
    }

    public synchronized void setTotalMergersForUltimateLevel(long totalMergersForUltimateLevel) {
        if (this.totalMergersForUltimateLevel != -1L) {
            throw new ISE("Cannot set mergers for final level more than once", new Object[0]);
        }
        this.totalMergersForUltimateLevel = totalMergersForUltimateLevel;
    }

    public synchronized void addMergedBatchesForLevel(int level, long additionalMergedBatches) {
        if (this.totalMergingLevels != -1 && level >= this.totalMergingLevels) {
            throw new ISE("Cannot add merged batches for level %d. Valid levels range from 0 to %d", new Object[]{level, this.totalMergingLevels - 1});
        }
        this.levelToMergedBatches.compute(level, (l, mergedBatchesSoFar) -> mergedBatchesSoFar == null ? additionalMergedBatches : additionalMergedBatches + mergedBatchesSoFar);
    }

    public synchronized void markTriviallyComplete() {
        this.isTriviallyComplete = true;
    }

    public synchronized SuperSorterProgressSnapshot snapshot() {
        if (this.isTriviallyComplete) {
            return TRIVIALLY_COMPLETE_SNAPSHOT;
        }
        HashMap<Integer, Long> levelToTotalBatchesCopy = new HashMap<Integer, Long>(this.levelToTotalBatches);
        HashMap<Integer, Long> levelToMergedBatchesCopy = new HashMap<Integer, Long>(this.levelToMergedBatches);
        if (this.totalMergingLevels != -1 && this.totalMergersForUltimateLevel != -1L) {
            levelToTotalBatchesCopy.put(this.totalMergingLevels - 1, this.totalMergersForUltimateLevel);
        } else if (this.totalMergingLevels != -1) {
            levelToTotalBatchesCopy.put(this.totalMergingLevels - 1, -1L);
        }
        return new SuperSorterProgressSnapshot(this.totalMergingLevels, levelToTotalBatchesCopy, levelToMergedBatchesCopy, this.totalMergersForUltimateLevel, this.isTriviallyComplete);
    }
}

