/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;

public class FrameFilteredOffset
extends Offset {
    private final Offset baseOffset;
    private final ValueMatcher filterMatcher;

    public FrameFilteredOffset(Offset baseOffset, ColumnSelectorFactory columnSelectorFactory, Filter postFilter) {
        this.baseOffset = baseOffset;
        this.filterMatcher = postFilter.makeMatcher(columnSelectorFactory);
        this.incrementIfNeededOnCreationOrReset();
    }

    @Override
    public void increment() {
        while (!Thread.currentThread().isInterrupted()) {
            this.baseOffset.increment();
            if (this.baseOffset.withinBounds() && !this.filterMatcher.matches()) continue;
            return;
        }
    }

    @Override
    public boolean withinBounds() {
        return this.baseOffset.withinBounds();
    }

    @Override
    public void reset() {
        this.baseOffset.reset();
        this.incrementIfNeededOnCreationOrReset();
    }

    private void incrementIfNeededOnCreationOrReset() {
        if (this.baseOffset.withinBounds() && !this.filterMatcher.matches()) {
            this.increment();
            BaseQuery.checkInterrupted();
        }
    }

    @Override
    public ReadableOffset getBaseReadableOffset() {
        return this.baseOffset.getBaseReadableOffset();
    }

    @Override
    public Offset clone() {
        throw new UnsupportedOperationException("FrameFilteredOffset cannot be cloned");
    }

    @Override
    public int getOffset() {
        return this.baseOffset.getOffset();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("baseOffset", this.baseOffset);
        inspector.visit("filterMatcher", this.filterMatcher);
    }
}

