/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.query.QueryContexts;

public class QueryContext {
    private final Map<String, Object> defaultParams;
    private final Map<String, Object> userParams;
    private final Map<String, Object> systemParams;
    @Nullable
    private Map<String, Object> mergedParams;

    public QueryContext() {
        this(null);
    }

    public QueryContext(@Nullable Map<String, Object> userParams) {
        this(new TreeMap<String, Object>(), userParams == null ? new TreeMap<String, Object>() : new TreeMap<String, Object>(userParams), new TreeMap<String, Object>());
    }

    private QueryContext(Map<String, Object> defaultParams, Map<String, Object> userParams, Map<String, Object> systemParams) {
        this.defaultParams = defaultParams;
        this.userParams = userParams;
        this.systemParams = systemParams;
        this.mergedParams = null;
    }

    private void invalidateMergedParams() {
        this.mergedParams = null;
    }

    public boolean isEmpty() {
        return this.defaultParams.isEmpty() && this.userParams.isEmpty() && this.systemParams.isEmpty();
    }

    public void addDefaultParam(String key, Object val) {
        this.invalidateMergedParams();
        this.defaultParams.put(key, val);
    }

    public void addDefaultParams(Map<String, Object> defaultParams) {
        this.invalidateMergedParams();
        this.defaultParams.putAll(defaultParams);
    }

    public void addSystemParam(String key, Object val) {
        this.invalidateMergedParams();
        this.systemParams.put(key, val);
    }

    public Object removeUserParam(String key) {
        this.invalidateMergedParams();
        return this.userParams.remove(key);
    }

    public Map<String, Object> getUserParams() {
        return this.userParams;
    }

    public boolean isDebug() {
        return this.getAsBoolean("debug", false);
    }

    public boolean isEnableJoinLeftScanDirect() {
        return this.getAsBoolean("enableJoinLeftTableScanDirect", false);
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    @Nullable
    public Object get(String key) {
        Object val = this.systemParams.get(key);
        if (val != null) {
            return val;
        }
        val = this.userParams.get(key);
        return val == null ? this.defaultParams.get(key) : val;
    }

    public Object getOrDefault(String key, Object defaultValue) {
        Object val = this.get(key);
        return val == null ? defaultValue : val;
    }

    @Nullable
    public String getAsString(String key) {
        return (String)this.get(key);
    }

    public boolean getAsBoolean(String parameter, boolean defaultValue) {
        return QueryContexts.getAsBoolean(parameter, this.get(parameter), defaultValue);
    }

    public int getAsInt(String parameter, int defaultValue) {
        return QueryContexts.getAsInt(parameter, this.get(parameter), defaultValue);
    }

    public long getAsLong(String parameter, long defaultValue) {
        return QueryContexts.getAsLong(parameter, this.get(parameter), defaultValue);
    }

    public HumanReadableBytes getAsHumanReadableBytes(String parameter, HumanReadableBytes defaultValue) {
        return QueryContexts.getAsHumanReadableBytes(parameter, this.get(parameter), defaultValue);
    }

    public Map<String, Object> getMergedParams() {
        if (this.mergedParams == null) {
            TreeMap<String, Object> merged = new TreeMap<String, Object>(this.defaultParams);
            merged.putAll(this.userParams);
            merged.putAll(this.systemParams);
            this.mergedParams = Collections.unmodifiableMap(merged);
        }
        return this.mergedParams;
    }

    public QueryContext copy() {
        return new QueryContext(new TreeMap<String, Object>(this.defaultParams), new TreeMap<String, Object>(this.userParams), new TreeMap<String, Object>(this.systemParams));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryContext context = (QueryContext)o;
        return this.getMergedParams().equals(context.getMergedParams());
    }

    public int hashCode() {
        return Objects.hash(this.getMergedParams());
    }

    public String toString() {
        return "QueryContext{defaultParams=" + this.defaultParams + ", userParams=" + this.userParams + ", systemParams=" + this.systemParams + '}';
    }
}

