/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.io.Closeable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.segment.SegmentReference;

public class ReferenceCountingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunnerFactory<T, Query<T>> factory;
    private final SegmentReference segment;
    private final SegmentDescriptor descriptor;

    public ReferenceCountingSegmentQueryRunner(QueryRunnerFactory<T, Query<T>> factory, SegmentReference segment, SegmentDescriptor descriptor) {
        this.factory = factory;
        this.segment = segment;
        this.descriptor = descriptor;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        return this.segment.acquireReferences().map(closeable -> {
            try {
                Sequence<T> baseSequence = this.factory.createRunner(this.segment).run(queryPlus, responseContext);
                return Sequences.withBaggage(baseSequence, (Closeable)closeable);
            }
            catch (Throwable t) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    t.addSuppressed(e);
                }
                throw t;
            }
        }).orElseGet(() -> new ReportTimelineMissingSegmentQueryRunner(this.descriptor).run(queryPlus, responseContext));
    }
}

