/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class FloatSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Ordering(){

        public int compare(Object o, Object o1) {
            return Float.compare(((Number)o).floatValue(), ((Number)o1).floatValue());
        }
    }.nullsFirst();
    private final BaseFloatColumnValueSelector selector;
    private float sum;

    static double combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).floatValue() + ((Number)rhs).floatValue();
    }

    public FloatSumAggregator(BaseFloatColumnValueSelector selector) {
        this.selector = selector;
        this.sum = 0.0f;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.getFloat();
    }

    @Override
    public Object get() {
        return Float.valueOf(this.sum);
    }

    @Override
    public float getFloat() {
        return this.sum;
    }

    @Override
    public long getLong() {
        return (long)this.sum;
    }

    @Override
    public double getDouble() {
        return this.sum;
    }

    @Override
    public void close() {
    }
}

