/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.LikeDimFilter;

public class LikeExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "like";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(final List<Expr> args) {
        String escape;
        this.validationHelperCheckAnyOfArgumentCount(args, new int[]{2, 3});
        Expr arg = args.get(0);
        final Expr patternExpr = args.get(1);
        final Expr escapeExpr = args.size() > 2 ? args.get(2) : null;
        this.validationHelperCheckArgIsLiteral(patternExpr, "pattern");
        if (escapeExpr != null) {
            this.validationHelperCheckArgIsLiteral(escapeExpr, "escape");
        }
        String string = escape = escapeExpr == null ? null : (String)escapeExpr.getLiteralValue();
        if (escape != null && escape.length() != 1) {
            throw this.validationFailed("escape must be null or a single character", new Object[0]);
        }
        Character escapeChar = escape == null ? null : Character.valueOf(escape.charAt(0));
        final LikeDimFilter.LikeMatcher likeMatcher = LikeDimFilter.LikeMatcher.from(NullHandling.nullToEmptyIfNeeded((String)((String)patternExpr.getLiteralValue())), escapeChar);
        class LikeExtractExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            LikeExtractExpr(Expr arg) {
                super(LikeExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.ofLongBoolean((boolean)likeMatcher.matches(this.arg.eval(bindings).asString()));
            }

            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(LikeExprMacro.this.apply(shuttle.visitAll(args)));
            }

            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.LONG;
            }

            public String stringify() {
                if (escapeExpr != null) {
                    return StringUtils.format((String)"%s(%s, %s, %s)", (Object[])new Object[]{LikeExprMacro.FN_NAME, this.arg.stringify(), patternExpr.stringify(), escapeExpr.stringify()});
                }
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{LikeExprMacro.FN_NAME, this.arg.stringify(), patternExpr.stringify()});
            }
        }
        return new LikeExtractExpr(arg);
    }
}

