/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;

public class RegexpExtractExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "regexp_extract";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(final List<Expr> args) {
        Expr indexExpr;
        this.validationHelperCheckAnyOfArgumentCount(args, new int[]{2, 3});
        Expr arg = args.get(0);
        final Expr patternExpr = args.get(1);
        Expr expr = indexExpr = args.size() > 2 ? args.get(2) : null;
        if (!ExprUtils.isStringLiteral(patternExpr)) {
            throw this.validationFailed("pattern must be a string literal", new Object[0]);
        }
        if (!(indexExpr == null || indexExpr.isLiteral() && indexExpr.getLiteralValue() instanceof Number)) {
            throw this.validationFailed("index must be a numeric literal", new Object[0]);
        }
        final Pattern pattern = Pattern.compile(StringUtils.nullToEmptyNonDruidDataString((String)((String)patternExpr.getLiteralValue())));
        final int index = indexExpr == null ? 0 : ((Number)indexExpr.getLiteralValue()).intValue();
        class RegexpExtractExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            RegexpExtractExpr(Expr arg) {
                super(RegexpExtractExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String s = NullHandling.nullToEmptyIfNeeded((String)this.arg.eval(bindings).asString());
                if (s == null) {
                    return ExprEval.of(null);
                }
                Matcher matcher = pattern.matcher(NullHandling.nullToEmptyIfNeeded((String)s));
                String retVal = matcher.find() ? matcher.group(index) : null;
                return ExprEval.of((String)retVal);
            }

            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(RegexpExtractExprMacro.this.apply(shuttle.visitAll(args)));
            }

            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.STRING;
            }

            public String stringify() {
                if (indexExpr != null) {
                    return StringUtils.format((String)"%s(%s, %s, %s)", (Object[])new Object[]{RegexpExtractExprMacro.FN_NAME, this.arg.stringify(), patternExpr.stringify(), indexExpr.stringify()});
                }
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{RegexpExtractExprMacro.FN_NAME, this.arg.stringify(), patternExpr.stringify()});
            }
        }
        return new RegexpExtractExpr(arg);
    }
}

